/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.quad.BakedQuadView;
import net.caffeinemc.mods.sodium.client.render.helper.ListStorage;
import net.caffeinemc.mods.sodium.client.render.helper.TextureHelper;
import net.caffeinemc.mods.sodium.client.render.model.EncodingFormat;
import net.caffeinemc.mods.sodium.client.render.model.QuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.model.SodiumQuadAtlas;
import net.caffeinemc.mods.sodium.client.render.model.SodiumShadeMode;
import net.caffeinemc.mods.sodium.client.render.texture.SodiumSpriteFinder;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import net.minecraft.class_9851;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public abstract class MutableQuadViewImpl
extends QuadViewImpl
implements ListStorage {
    @Nullable
    private class_1058 cachedSprite;
    private List<class_10889> cachedList;
    static final int[] DEFAULT = (int[])EncodingFormat.EMPTY.clone();

    @Override
    public List<class_10889> clearAndGet() {
        if (this.cachedList == null) {
            this.cachedList = new ArrayList<class_10889>();
            return this.cachedList;
        }
        this.cachedList.clear();
        return this.cachedList;
    }

    @Nullable
    public class_1058 cachedSprite() {
        return this.cachedSprite;
    }

    public void cachedSprite(@Nullable class_1058 sprite) {
        this.cachedSprite = sprite;
    }

    public class_1058 sprite(SodiumSpriteFinder finder) {
        class_1058 sprite = this.cachedSprite;
        if (sprite == null) {
            this.cachedSprite = sprite = finder.find(this);
        }
        return sprite;
    }

    public void clear() {
        System.arraycopy(DEFAULT, 0, this.data, this.baseIndex, EncodingFormat.TOTAL_STRIDE);
        this.isGeometryInvalid = true;
        this.nominalFace = null;
        this.cachedSprite(null);
    }

    @Override
    public void load() {
        super.load();
        this.cachedSprite(null);
    }

    public MutableQuadViewImpl setPos(int vertexIndex, float x, float y, float z) {
        int index = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_X;
        this.data[index] = Float.floatToRawIntBits(x);
        this.data[index + 1] = Float.floatToRawIntBits(y);
        this.data[index + 2] = Float.floatToRawIntBits(z);
        this.isGeometryInvalid = true;
        return this;
    }

    public MutableQuadViewImpl setColor(int vertexIndex, int color) {
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_COLOR] = color;
        return this;
    }

    public MutableQuadViewImpl setUV(int vertexIndex, float u, float v) {
        int i = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_U;
        this.data[i] = Float.floatToRawIntBits(u);
        this.data[i + 1] = Float.floatToRawIntBits(v);
        this.cachedSprite(null);
        return this;
    }

    public MutableQuadViewImpl spriteBake(class_1058 sprite, int bakeFlags) {
        TextureHelper.bakeSprite(this, sprite, bakeFlags);
        this.cachedSprite(sprite);
        return this;
    }

    public MutableQuadViewImpl setLight(int vertexIndex, int lightmap) {
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_LIGHTMAP] = lightmap;
        return this;
    }

    protected void normalFlags(int flags) {
        this.data[this.baseIndex + 0] = EncodingFormat.normalFlags(this.data[this.baseIndex + 0], flags);
    }

    public MutableQuadViewImpl setNormal(int vertexIndex, float x, float y, float z) {
        this.normalFlags(this.normalFlags() | 1 << vertexIndex);
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL] = NormI8.pack(x, y, z);
        return this;
    }

    public final void populateMissingNormals() {
        int normalFlags = this.normalFlags();
        if (normalFlags == 15) {
            return;
        }
        int packedFaceNormal = this.packedFaceNormal();
        for (int v = 0; v < 4; ++v) {
            if ((normalFlags & 1 << v) != 0) continue;
            this.data[this.baseIndex + v * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL] = packedFaceNormal;
        }
        this.normalFlags(15);
    }

    public final MutableQuadViewImpl setCullFace(@Nullable class_2350 face) {
        this.data[this.baseIndex + 0] = EncodingFormat.cullFace(this.data[this.baseIndex + 0], face);
        this.setNominalFace(face);
        return this;
    }

    public final MutableQuadViewImpl setNominalFace(@Nullable class_2350 face) {
        this.nominalFace = face;
        return this;
    }

    public MutableQuadViewImpl setRenderType(@Nullable class_11515 renderLayer) {
        this.data[this.baseIndex + 0] = EncodingFormat.renderLayer(this.data[this.baseIndex + 0], renderLayer);
        return this;
    }

    public MutableQuadViewImpl setEmissive(boolean emissive) {
        this.data[this.baseIndex + 0] = EncodingFormat.emissive(this.data[this.baseIndex + 0], emissive);
        return this;
    }

    public MutableQuadViewImpl setDiffuseShade(boolean shade) {
        this.data[this.baseIndex + 0] = EncodingFormat.diffuseShade(this.data[this.baseIndex + 0], shade);
        return this;
    }

    public MutableQuadViewImpl setAmbientOcclusion(class_9851 ao) {
        Objects.requireNonNull(ao, "ambient occlusion TriState may not be null");
        this.data[this.baseIndex + 0] = EncodingFormat.ambientOcclusion(this.data[this.baseIndex + 0], ao);
        return this;
    }

    public MutableQuadViewImpl setGlint(@Nullable class_10444.class_10445 glint) {
        this.data[this.baseIndex + 0] = EncodingFormat.glint(this.data[this.baseIndex + 0], glint);
        return this;
    }

    public MutableQuadViewImpl setShadeMode(SodiumShadeMode mode) {
        Objects.requireNonNull(mode, "ShadeMode may not be null");
        this.data[this.baseIndex + 0] = EncodingFormat.shadeMode(this.data[this.baseIndex + 0], mode);
        return this;
    }

    public final MutableQuadViewImpl setTintIndex(int tintIndex) {
        this.data[this.baseIndex + 2] = tintIndex;
        return this;
    }

    public final MutableQuadViewImpl setQuadAtlas(SodiumQuadAtlas atlas) {
        this.data[this.baseIndex + 0] = EncodingFormat.quadAtlas(this.data[this.baseIndex + 0], atlas);
        return this;
    }

    public final MutableQuadViewImpl setTag(int tag) {
        this.data[this.baseIndex + 3] = tag;
        return this;
    }

    public MutableQuadViewImpl copyFrom(QuadViewImpl q) {
        System.arraycopy(q.data, q.baseIndex, this.data, this.baseIndex, EncodingFormat.TOTAL_STRIDE);
        this.nominalFace = q.nominalFace;
        this.isGeometryInvalid = q.isGeometryInvalid;
        if (!this.isGeometryInvalid) {
            this.faceNormal.set((Vector3fc)q.faceNormal);
        }
        if (q instanceof MutableQuadViewImpl) {
            MutableQuadViewImpl mutableQuad = (MutableQuadViewImpl)q;
            this.cachedSprite(mutableQuad.cachedSprite());
        } else {
            this.cachedSprite(null);
        }
        return this;
    }

    private void fromVanillaInternal(BakedQuadView quadData) {
        boolean hasNormals = false;
        for (int i = 0; i < 4; ++i) {
            this.setPos(i, quadData.getX(i), quadData.getY(i), quadData.getZ(i));
            this.setColor(i, quadData.getColor(i));
            this.setUV(i, quadData.getTexU(i), quadData.getTexV(i));
            this.setLight(i, quadData.getMaxLightQuad(i));
            int normal = quadData.getVertexNormal(i);
            if (normal != 0) {
                hasNormals = true;
            }
            this.setNormal(i, NormI8.unpackX(normal), NormI8.unpackY(normal), NormI8.unpackZ(normal));
        }
        this.normalFlags(hasNormals ? 15 : 0);
    }

    public final MutableQuadViewImpl fromBakedQuad(class_777 quad) {
        this.fromVanillaInternal((BakedQuadView)quad);
        this.setNominalFace(quad.comp_3723());
        this.setDiffuseShade(quad.comp_3725());
        this.setTintIndex(quad.comp_3722());
        this.setAmbientOcclusion(((BakedQuadView)quad).hasAO() ? class_9851.field_52396 : class_9851.field_52395);
        this.setEmissive(quad.comp_3726() == 15);
        BakedQuadView bakedView = (BakedQuadView)quad;
        NormI8.unpack(bakedView.getFaceNormal(), this.faceNormal);
        this.data[this.baseIndex + 1] = bakedView.getFaceNormal();
        int headerBits = EncodingFormat.lightFace(this.data[this.baseIndex + 0], bakedView.getLightFace());
        headerBits = EncodingFormat.normalFace(headerBits, bakedView.getNormalFace());
        this.data[this.baseIndex + 0] = EncodingFormat.geometryFlags(headerBits, bakedView.getFlags());
        this.isGeometryInvalid = false;
        SodiumQuadAtlas atlas = SodiumQuadAtlas.of(quad.comp_3724().method_45852());
        if (atlas == null) {
            atlas = SodiumQuadAtlas.BLOCK;
        }
        this.setQuadAtlas(atlas);
        this.cachedSprite(quad.comp_3724());
        return this;
    }

    public abstract void emitDirectly();

    static {
        MutableQuadViewImpl quad = new MutableQuadViewImpl(){

            @Override
            public void emitDirectly() {
            }
        };
        quad.data = DEFAULT;
        quad.setColor(0, -1);
        quad.setColor(1, -1);
        quad.setColor(2, -1);
        quad.setColor(3, -1);
        quad.setCullFace(null);
        quad.setRenderType(null);
        quad.setDiffuseShade(true);
        quad.setQuadAtlas(SodiumQuadAtlas.BLOCK);
        quad.setAmbientOcclusion(class_9851.field_52396);
        quad.setGlint(null);
        quad.setTintIndex(-1);
    }
}

