/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.wrapper;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.caffeinemc.mods.sodium.client.render.frapi.wrapper.QuadViewWrapper;
import net.caffeinemc.mods.sodium.client.render.model.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.model.QuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.model.SodiumQuadAtlas;
import net.caffeinemc.mods.sodium.client.render.model.SodiumShadeMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadAtlas;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadTransform;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.ShadeMode;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_11515;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import net.minecraft.class_9851;
import org.jspecify.annotations.Nullable;

public class MutableQuadViewWrapper
extends QuadViewWrapper
implements QuadEmitter {
    protected static final QuadTransform NO_TRANSFORM = q -> true;
    private static final class_9851[] TO_SODIUM = new class_9851[]{class_9851.field_52395, class_9851.field_52396, class_9851.field_52394};
    private final MutableQuadViewImpl mutableQuad;
    protected QuadTransform activeTransform = NO_TRANSFORM;
    private final ObjectArrayList<QuadTransform> transformStack = new ObjectArrayList();
    private final QuadTransform stackTransform = q -> {
        int i = this.transformStack.size() - 1;
        while (i >= 0) {
            if (((QuadTransform)this.transformStack.get(i--)).transform(q)) continue;
            return false;
        }
        return true;
    };

    public MutableQuadViewWrapper(MutableQuadViewImpl quad) {
        super(quad);
        this.mutableQuad = quad;
    }

    public QuadEmitter pos(int vertexIndex, float x, float y, float z) {
        this.mutableQuad.setPos(vertexIndex, x, y, z);
        return this;
    }

    public QuadEmitter color(int vertexIndex, int color) {
        this.mutableQuad.setColor(vertexIndex, color);
        return this;
    }

    public QuadEmitter uv(int vertexIndex, float u, float v) {
        this.mutableQuad.setUV(vertexIndex, u, v);
        return this;
    }

    public QuadEmitter lightmap(int vertexIndex, int lightmap) {
        this.mutableQuad.setLight(vertexIndex, lightmap);
        return this;
    }

    public QuadEmitter normal(int vertexIndex, float x, float y, float z) {
        this.mutableQuad.setNormal(vertexIndex, x, y, z);
        return this;
    }

    public QuadEmitter nominalFace(@Nullable class_2350 face) {
        this.mutableQuad.setNominalFace(face);
        return this;
    }

    public QuadEmitter cullFace(@Nullable class_2350 face) {
        this.mutableQuad.setCullFace(face);
        return this;
    }

    public QuadEmitter renderLayer(@Nullable class_11515 renderLayer) {
        this.mutableQuad.setRenderType(renderLayer);
        return this;
    }

    public QuadEmitter emissive(boolean emissive) {
        this.mutableQuad.setEmissive(emissive);
        return this;
    }

    public QuadEmitter diffuseShade(boolean shade) {
        this.mutableQuad.setDiffuseShade(shade);
        return this;
    }

    public QuadEmitter ambientOcclusion(TriState ao) {
        this.mutableQuad.setAmbientOcclusion(TO_SODIUM[ao.ordinal()]);
        return this;
    }

    public QuadEmitter glint(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_10444.class_10445 glint) {
        this.mutableQuad.setGlint(glint);
        return this;
    }

    public QuadEmitter shadeMode(ShadeMode mode) {
        this.mutableQuad.setShadeMode(mode == ShadeMode.ENHANCED ? SodiumShadeMode.ENHANCED : SodiumShadeMode.VANILLA);
        return this;
    }

    public QuadEmitter atlas(QuadAtlas quadAtlas) {
        this.mutableQuad.setQuadAtlas(quadAtlas == QuadAtlas.BLOCK ? SodiumQuadAtlas.BLOCK : SodiumQuadAtlas.ITEM);
        return this;
    }

    public QuadEmitter tintIndex(int tintIndex) {
        this.mutableQuad.setTintIndex(tintIndex);
        return this;
    }

    public QuadEmitter tag(int tag) {
        this.mutableQuad.setTag(tag);
        return this;
    }

    public QuadEmitter copyFrom(QuadView quad) {
        this.mutableQuad.copyFrom((QuadViewImpl)quad);
        return this;
    }

    public QuadEmitter fromBakedQuad(class_777 quad) {
        this.mutableQuad.fromBakedQuad(quad);
        return this;
    }

    public void pushTransform(QuadTransform transform) {
        if (transform == null) {
            throw new NullPointerException("QuadTransform cannot be null!");
        }
        this.transformStack.push((Object)transform);
        if (this.transformStack.size() == 1) {
            this.activeTransform = transform;
        } else if (this.transformStack.size() == 2) {
            this.activeTransform = this.stackTransform;
        }
    }

    public void popTransform() {
        this.transformStack.pop();
        if (this.transformStack.isEmpty()) {
            this.activeTransform = NO_TRANSFORM;
        } else if (this.transformStack.size() == 1) {
            this.activeTransform = (QuadTransform)this.transformStack.getFirst();
        }
    }

    public QuadEmitter spriteBake(class_1058 sprite, int bakeFlags) {
        this.mutableQuad.spriteBake(sprite, bakeFlags);
        return this;
    }

    public final void transformAndEmit() {
        if (this.activeTransform.transform((MutableQuadView)this)) {
            this.mutableQuad.emitDirectly();
        }
    }

    public final QuadEmitter emit() {
        this.transformAndEmit();
        this.mutableQuad.clear();
        return this;
    }

    @Override
    public MutableQuadViewImpl getOriginal() {
        return this.mutableQuad;
    }

    @Override
    public QuadAtlas atlas() {
        return this.mutableQuad.getQuadAtlas() == SodiumQuadAtlas.BLOCK ? QuadAtlas.BLOCK : QuadAtlas.ITEM;
    }
}

