/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.builder;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.function.Function;
import net.caffeinemc.mods.sodium.api.config.ConfigState;
import net.caffeinemc.mods.sodium.api.config.structure.OptionBuilder;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.config.value.ConstantValue;
import net.caffeinemc.mods.sodium.client.config.value.DependentValue;
import net.caffeinemc.mods.sodium.client.config.value.DynamicValue;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.apache.commons.lang3.Validate;

public abstract class OptionBuilderImpl<O extends Option>
implements OptionBuilder {
    final class_2960 id;
    private O baseOption;
    private class_2561 name;
    private DependentValue<Boolean> enabled;

    OptionBuilderImpl(class_2960 id) {
        this.id = id;
    }

    abstract O build();

    abstract Class<O> getOptionClass();

    public O buildWithBaseOption(Option baseOption) {
        Validate.isTrue((boolean)this.getOptionClass().isInstance(baseOption), (String)"Base option must be of type %s", (Object[])new Object[]{this.getOptionClass().getSimpleName()});
        Option castedBaseOption = baseOption;
        this.baseOption = castedBaseOption;
        return this.build();
    }

    void validateData() {
        Validate.notNull((Object)this.getName(), (String)"Name must be set", (Object[])new Object[0]);
    }

    void prepareBuild() {
        this.validateData();
        if (this.getEnabled() == null) {
            this.enabled = new ConstantValue<Boolean>(true);
        }
    }

    Collection<class_2960> getDependencies() {
        ObjectLinkedOpenHashSet dependencies = new ObjectLinkedOpenHashSet();
        dependencies.addAll(this.getEnabled().getDependencies());
        return dependencies;
    }

    public <V> V getFirstNotNull(V overlayValue, Function<O, V> extractor) {
        if (overlayValue != null) {
            return overlayValue;
        }
        if (this.baseOption != null) {
            return extractor.apply(this.baseOption);
        }
        return null;
    }

    class_2561 getName() {
        return this.getFirstNotNull(this.name, Option::getName);
    }

    DependentValue<Boolean> getEnabled() {
        return this.getFirstNotNull(this.enabled, Option::getEnabled);
    }

    @Override
    public OptionBuilder setName(class_2561 name) {
        Validate.notNull((Object)name, (String)"Argument must not be null", (Object[])new Object[0]);
        this.name = name;
        return this;
    }

    @Override
    public OptionBuilder setEnabled(boolean available) {
        this.enabled = new ConstantValue<Boolean>(available);
        return this;
    }

    @Override
    public OptionBuilder setEnabledProvider(Function<ConfigState, Boolean> provider, class_2960 ... dependencies) {
        Validate.notNull(provider, (String)"Argument must not be null", (Object[])new Object[0]);
        this.enabled = new DynamicValue<Boolean>(provider, dependencies);
        return this;
    }
}

