/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.builder;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.caffeinemc.mods.sodium.api.config.ConfigState;
import net.caffeinemc.mods.sodium.api.config.option.FlagHook;
import net.caffeinemc.mods.sodium.api.config.structure.ColorThemeBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.ModOptionsBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.OptionBuilder;
import net.caffeinemc.mods.sodium.api.config.structure.PageBuilder;
import net.caffeinemc.mods.sodium.client.config.builder.ColorThemeBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.builder.OptionBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.builder.PageBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.structure.FlagHookImpl;
import net.caffeinemc.mods.sodium.client.config.structure.ModOptions;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.config.structure.OptionOverlay;
import net.caffeinemc.mods.sodium.client.config.structure.OptionOverride;
import net.caffeinemc.mods.sodium.client.config.structure.Page;
import net.caffeinemc.mods.sodium.client.gui.ColorTheme;
import net.minecraft.class_2960;
import org.apache.commons.lang3.Validate;

class ModOptionsBuilderImpl
implements ModOptionsBuilder {
    private final String configId;
    private String name;
    private String version;
    private ColorTheme theme;
    private class_2960 icon;
    private final List<Page> pages = new ArrayList<Page>();
    private List<OptionOverride> optionOverrides;
    private List<OptionOverlay> optionOverlays;
    private Collection<FlagHook> flagHooks;

    ModOptionsBuilderImpl(String configId, String name, String version) {
        this.configId = configId;
        this.name = name;
        this.version = version;
    }

    ModOptions build() {
        List<Object> overlays;
        Validate.notEmpty((CharSequence)this.name, (String)"Name must not be empty", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)this.version, (String)"Version must not be empty", (Object[])new Object[0]);
        List<Object> overrides = this.optionOverrides == null ? List.of() : this.optionOverrides;
        List<Object> list = overlays = this.optionOverlays == null ? List.of() : this.optionOverlays;
        if (this.pages.isEmpty() && overrides.isEmpty() && overlays.isEmpty()) {
            throw new IllegalStateException("At least one page, option override, or option overlay must be added");
        }
        if (this.theme == null) {
            this.theme = ColorTheme.PRESETS[Math.abs(this.configId.hashCode()) % ColorTheme.PRESETS.length];
        }
        return new ModOptions(this.configId, this.name, this.version, this.theme, this.icon, (ImmutableList<Page>)ImmutableList.copyOf(this.pages), overrides, overlays, this.flagHooks);
    }

    @Override
    public ModOptionsBuilder setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ModOptionsBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    @Override
    public ModOptionsBuilder formatVersion(Function<String, String> versionFormatter) {
        this.version = versionFormatter.apply(this.version);
        return this;
    }

    @Override
    public ModOptionsBuilder setColorTheme(ColorThemeBuilder theme) {
        this.theme = ((ColorThemeBuilderImpl)theme).build();
        return this;
    }

    @Override
    public ModOptionsBuilder setIcon(class_2960 texture) {
        this.icon = texture;
        return this;
    }

    @Override
    public ModOptionsBuilder addPage(PageBuilder builder) {
        this.pages.add(((PageBuilderImpl)((Object)builder)).build());
        return this;
    }

    @Override
    public ModOptionsBuilder registerOptionReplacement(class_2960 target, OptionBuilder replacement) {
        OptionOverride override = new OptionOverride(target, this.configId, (Option)((OptionBuilderImpl)replacement).build());
        if (this.optionOverrides == null) {
            this.optionOverrides = new ArrayList<OptionOverride>();
        }
        this.optionOverrides.add(override);
        return this;
    }

    @Override
    public ModOptionsBuilder registerOptionOverlay(class_2960 target, OptionBuilder overlay) {
        OptionOverlay optionOverlay = new OptionOverlay(target, this.configId, (OptionBuilderImpl)overlay);
        if (this.optionOverlays == null) {
            this.optionOverlays = new ArrayList<OptionOverlay>();
        }
        this.optionOverlays.add(optionOverlay);
        return this;
    }

    @Override
    public ModOptionsBuilder registerFlagHook(BiConsumer<Collection<class_2960>, ConfigState> hook, class_2960 ... triggers) {
        return this.registerFlagHook(new FlagHookImpl(hook, List.of(triggers)));
    }

    @Override
    public ModOptionsBuilder registerFlagHook(FlagHook hook) {
        if (this.flagHooks == null) {
            this.flagHooks = new ObjectArrayList();
        }
        this.flagHooks.add(hook);
        return this;
    }
}

