/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.api.util;

import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.api.util.ColorU8;

public class ColorARGB
implements ColorU8 {
    private static final int ALPHA_COMPONENT_OFFSET = 24;
    private static final int RED_COMPONENT_OFFSET = 16;
    private static final int GREEN_COMPONENT_OFFSET = 8;
    private static final int BLUE_COMPONENT_OFFSET = 0;
    private static final int RED_COMPONENT_MASK = 0xFF0000;
    private static final int GREEN_COMPONENT_MASK = 65280;
    private static final int BLUE_COMPONENT_MASK = 255;
    private static final int ALPHA_COMPONENT_MASK = -16777216;

    public static int pack(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public static int pack(int r, int g, int b) {
        return ColorARGB.pack(r, g, b, 255);
    }

    public static int unpackAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int unpackRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int unpackGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int unpackBlue(int color) {
        return color >> 0 & 0xFF;
    }

    public static int toABGR(int color, int alpha) {
        return Integer.reverseBytes(color << 8 | alpha);
    }

    public static int toABGR(int color, float alpha) {
        return ColorARGB.toABGR(color, ColorU8.normalizedFloatToByte(alpha));
    }

    public static int toABGR(int color) {
        return Integer.reverseBytes(Integer.rotateLeft(color, 8));
    }

    public static int fromABGR(int color) {
        return Integer.rotateRight(Integer.reverseBytes(color), 8);
    }

    public static int withAlpha(int rgb, int alpha) {
        return alpha << 24 | rgb & 0xFFFFFF;
    }

    public static int transferAlpha(int color, int alphaColor) {
        return ColorARGB.withAlpha(color, ColorARGB.unpackAlpha(alphaColor));
    }

    public static int mulRGB(int color, int factor) {
        return ColorMixer.mul(color, factor) & 0xFFFFFF | color & 0xFF000000;
    }

    public static int mulRGB(int color, float factor) {
        return ColorARGB.mulRGB(color, ColorU8.normalizedFloatToByte(factor));
    }

    public static float[] toHSV(int color) {
        float r = (float)ColorARGB.unpackRed(color) / 255.0f;
        float g = (float)ColorARGB.unpackGreen(color) / 255.0f;
        float b = (float)ColorARGB.unpackBlue(color) / 255.0f;
        float cmax = Math.max(r, Math.max(g, b));
        float cmin = Math.min(r, Math.min(g, b));
        float diff = cmax - cmin;
        float h = -1.0f;
        float s = -1.0f;
        if (cmax == cmin) {
            h = 0.0f;
        } else if (cmax == r) {
            h = (0.1666f * ((g - b) / diff) + 1.0f) % 1.0f;
        } else if (cmax == g) {
            h = (0.1666f * ((b - r) / diff) + 0.333f) % 1.0f;
        } else if (cmax == b) {
            h = (0.1666f * ((r - g) / diff) + 0.666f) % 1.0f;
        }
        s = cmax == 0.0f ? 0.0f : diff / cmax;
        return new float[]{h, s, cmax};
    }

    private static int pack(float r, float g, float b) {
        return ColorARGB.pack(ColorU8.normalizedFloatToByte(r), ColorU8.normalizedFloatToByte(g), ColorU8.normalizedFloatToByte(b));
    }

    public static int fromHSV(float hue, float saturation, float value) {
        int h = (int)(hue * 6.0f) % 6;
        float f = hue * 6.0f - (float)h;
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        return switch (h) {
            case 0 -> ColorARGB.pack(value, t, p);
            case 1 -> ColorARGB.pack(q, value, p);
            case 2 -> ColorARGB.pack(p, value, t);
            case 3 -> ColorARGB.pack(p, q, value);
            case 4 -> ColorARGB.pack(t, p, value);
            case 5 -> ColorARGB.pack(value, p, q);
            default -> 0;
        };
    }
}

