/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.blay09.mods.balm.world.BalmContainerProvider;
import net.blay09.mods.balm.world.BalmMenuProvider;
import net.blay09.mods.balm.world.DefaultContainer;
import net.blay09.mods.balm.world.level.block.entity.BalmBlockEntityUtils;
import net.blay09.mods.balm.world.level.block.entity.OnLoadHandler;
import net.blay09.mods.waystones.api.MutableWaystone;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.error.WaystoneEditError;
import net.blay09.mods.waystones.api.event.WaystoneInitializedEvent;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.component.WaystoneReferenceComponent;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneVisibilities;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.menu.WaystoneEditMenu;
import net.blay09.mods.waystones.menu.WaystoneModifierMenu;
import net.blay09.mods.waystones.store.SavedDataWaystonesStore;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9473;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class WaystoneBlockEntityBase
extends class_2586
implements OnLoadHandler,
BalmContainerProvider {
    protected final DefaultContainer container = new DefaultContainer(5){

        public int method_58350(class_1799 itemStack) {
            if (itemStack.method_41406((class_6880)ModItems.dormantShard)) {
                return 1;
            }
            return super.method_58350(itemStack);
        }

        public boolean method_5437(int slot, class_1799 itemStack) {
            if (itemStack.method_41406((class_6880)ModItems.dormantShard)) {
                return slot == 0;
            }
            return super.method_5437(slot, itemStack);
        }

        public void method_5431() {
            WaystoneBlockEntityBase.this.onInventoryChanged();
        }

        public boolean method_5443(class_1657 player) {
            return class_1263.method_49105((class_2586)WaystoneBlockEntityBase.this, (class_1657)player);
        }
    };
    private Waystone waystone = InvalidWaystone.INSTANCE;
    private UUID waystoneUid;
    private boolean shouldNotInitialize;
    private boolean silkTouched;

    protected void onInventoryChanged() {
    }

    public WaystoneBlockEntityBase(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected void method_11007(class_11372 output) {
        class_1262.method_5426((class_11372)output, (class_2371)this.container.getItems());
        output.method_71477("UUID", class_4844.field_25122, (Object)this.getEffectiveWaystoneUid());
    }

    public void method_11014(class_11368 input) {
        class_1262.method_5429((class_11368)input, (class_2371)this.container.getItems());
        input.method_71426("UUID", class_4844.field_25122).ifPresent(uuid -> {
            this.waystoneUid = uuid;
        });
        input.method_71426("Waystone", WaystoneImpl.CODEC.codec()).ifPresent(loadedWaystone -> {
            this.waystone = loadedWaystone;
        });
    }

    protected void method_57568(class_9473 input) {
        UUID waystoneUidFromComponent = Optional.ofNullable((WaystoneReferenceComponent)input.method_58694((class_9331)ModComponents.waystoneIdentity.comp_349())).map(WaystoneReferenceComponent::waystoneId).orElseGet(() -> (UUID)input.method_58694((class_9331)ModComponents.waystone.comp_349()));
        if (waystoneUidFromComponent != null) {
            this.waystoneUid = waystoneUidFromComponent;
        }
    }

    protected void method_57567(class_9323.class_9324 builder) {
        builder.method_57840((class_9331)ModComponents.waystoneIdentity.comp_349(), (Object)new WaystoneReferenceComponent(this.getEffectiveWaystoneUid(), this.waystone.getName()));
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return BalmBlockEntityUtils.createUpdatePacket((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return BalmBlockEntityUtils.createUpdateTag((class_7225.class_7874)registries, output -> output.method_71468("Waystone", WaystoneImpl.CODEC.codec(), (Object)this.getWaystone()));
    }

    public void onLoad() {
        Waystone backingWaystone = this.waystone;
        if (this.waystone instanceof WaystoneProxy) {
            backingWaystone = ((WaystoneProxy)this.waystone).getBackingWaystone();
        }
        if (backingWaystone instanceof WaystoneImpl && this.field_11863 != null) {
            ((WaystoneImpl)backingWaystone).setDimension((class_5321<class_1937>)this.field_11863.method_27983());
            ((WaystoneImpl)backingWaystone).setPos(this.field_11867);
        }
        BalmBlockEntityUtils.sync((class_2586)this);
    }

    public class_238 getRenderBoundingBox() {
        return new class_238((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (double)(this.field_11867.method_10263() + 1), (double)(this.field_11867.method_10264() + 2), (double)(this.field_11867.method_10260() + 1));
    }

    public Waystone getWaystone() {
        if (!(this.waystone.isValid() || this.field_11863 == null || this.field_11863.method_8608() || this.shouldNotInitialize)) {
            class_2680 state;
            if (this.waystoneUid != null) {
                this.waystone = new WaystoneProxy(this.field_11863.method_8503(), this.waystoneUid);
            }
            if (!this.waystone.isValid() && (state = this.method_11010()).method_26204() instanceof WaystoneBlockBase) {
                class_2586 blockEntity;
                WaystoneOrigin origin;
                class_2756 half = state.method_28498(WaystoneBlockBase.HALF) ? (class_2756)state.method_11654(WaystoneBlockBase.HALF) : class_2756.field_12607;
                WaystoneOrigin waystoneOrigin = origin = state.method_28498(WaystoneBlockBase.ORIGIN) ? (WaystoneOrigin)((Object)state.method_11654(WaystoneBlockBase.ORIGIN)) : WaystoneOrigin.UNKNOWN;
                if (half == class_2756.field_12607) {
                    this.initializeWaystone((class_5425)Objects.requireNonNull(this.field_11863), null, origin);
                } else if (half == class_2756.field_12609 && (blockEntity = this.field_11863.method_8321(this.field_11867.method_10074())) instanceof WaystoneBlockEntityBase) {
                    this.initializeFromBase((WaystoneBlockEntityBase)blockEntity);
                }
            }
            if (this.waystone.isValid()) {
                this.waystoneUid = this.waystone.getWaystoneUid();
                BalmBlockEntityUtils.sync((class_2586)this);
            }
        }
        return this.waystone;
    }

    protected abstract class_2960 getWaystoneType();

    public void initializeWaystone(class_5425 level, @Nullable class_1309 player, WaystoneOrigin origin) {
        WaystoneImpl waystone = new WaystoneImpl(this.getWaystoneType(), UUID.randomUUID(), (class_5321<class_1937>)level.method_8410().method_27983(), this.field_11867, origin, player != null ? player.method_5667() : null);
        SavedDataWaystonesStore.get(level.method_8410().method_8503()).addWaystone(waystone);
        ((Consumer)WaystoneInitializedEvent.EVENT.invoker()).accept(new WaystoneInitializedEvent(waystone));
        this.waystone = waystone;
        this.method_5431();
        BalmBlockEntityUtils.sync((class_2586)this);
    }

    public void initializeFromExisting(class_5425 level, WaystoneImpl existingWaystone, class_1799 itemStack) {
        this.waystone = existingWaystone;
        existingWaystone.setDimension((class_5321<class_1937>)level.method_8410().method_27983());
        existingWaystone.setPos(this.field_11867);
        existingWaystone.setTransient(false);
        SavedDataWaystonesStore.get(level.method_8410().method_8503()).updateWaystone(this.waystone);
        this.method_5431();
        BalmBlockEntityUtils.sync((class_2586)this);
    }

    public void initializeFromBase(WaystoneBlockEntityBase tileEntity) {
        this.waystone = tileEntity.getWaystone();
        this.method_5431();
        BalmBlockEntityUtils.sync((class_2586)this);
    }

    public void uninitializeWaystone() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.waystone.isValid()) {
                MinecraftServer server = serverLevel.method_8503();
                SavedDataWaystonesStore.get(server).removeWaystone(this.waystone);
                PlayerWaystoneManager.removeKnownWaystone(server, this.waystone);
                WaystoneSyncManager.sendWaystoneRemovalToAll(server, this.waystone, true);
            }
            this.waystone = InvalidWaystone.INSTANCE;
            this.shouldNotInitialize = true;
            class_2756 half = (class_2756)this.method_11010().method_11654((class_2769)WaystoneBlock.HALF);
            class_2338 otherPos = half == class_2756.field_12609 ? this.field_11867.method_10074() : this.field_11867.method_10084();
            class_2586 blockEntity = Objects.requireNonNull(this.field_11863).method_8321(otherPos);
            if (blockEntity instanceof WaystoneBlockEntityBase) {
                WaystoneBlockEntityBase waystoneTile = (WaystoneBlockEntityBase)blockEntity;
                waystoneTile.waystone = InvalidWaystone.INSTANCE;
                waystoneTile.shouldNotInitialize = true;
            }
            this.method_5431();
            BalmBlockEntityUtils.sync((class_2586)this);
        }
    }

    public void setSilkTouched(boolean silkTouched) {
        this.silkTouched = silkTouched;
    }

    public boolean canSilkTouch() {
        return false;
    }

    public boolean isSilkTouched() {
        return this.silkTouched;
    }

    public Optional<class_3908> getSelectionMenuProvider() {
        return Optional.empty();
    }

    public abstract class_2561 getName();

    public Optional<class_3908> getSettingsMenuProvider() {
        return Optional.of(new BalmMenuProvider<WaystoneEditMenu.Data>(){

            public class_2561 method_5476() {
                return class_2561.method_43469((String)"container.waystones.waystone_settings", (Object[])new Object[]{WaystoneBlockEntityBase.this.getName()});
            }

            public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 player) {
                Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone((class_3222)player, WaystoneBlockEntityBase.this.getWaystone());
                List<WaystoneVisibility> visibilityOptions = WaystoneVisibilities.getVisibilityOptions((class_3222)player, WaystoneBlockEntityBase.this.waystone);
                return new WaystoneEditMenu(i, WaystoneBlockEntityBase.this.getWaystone(), WaystoneBlockEntityBase.this.getModifierCount(), error.map(WaystoneEditError::getTranslationKey).map(class_2561::method_43471).orElse(null), visibilityOptions, WaystoneBlockEntityBase.this.getContainer());
            }

            public WaystoneEditMenu.Data getScreenOpeningData(class_3222 player) {
                Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone(player, WaystoneBlockEntityBase.this.getWaystone());
                List<WaystoneVisibility> visibilityOptions = WaystoneVisibilities.getVisibilityOptions(player, WaystoneBlockEntityBase.this.waystone);
                return new WaystoneEditMenu.Data(WaystoneBlockEntityBase.this.field_11867, WaystoneBlockEntityBase.this.getWaystone(), WaystoneBlockEntityBase.this.getModifierCount(), error.map(WaystoneEditError::getTranslationKey).map(class_2561::method_43471), visibilityOptions);
            }

            public class_9139<class_9129, WaystoneEditMenu.Data> getScreenStreamCodec() {
                return WaystoneEditMenu.STREAM_CODEC;
            }
        });
    }

    public Optional<class_3908> getModifierMenuProvider() {
        return Optional.of(new BalmMenuProvider<Waystone>(){

            public class_2561 method_5476() {
                return class_2561.method_43471((String)"container.waystones.waystone_modifiers");
            }

            public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 player) {
                return new WaystoneModifierMenu(i, playerInventory, WaystoneBlockEntityBase.this.getWaystone(), WaystoneBlockEntityBase.this.getContainer());
            }

            public Waystone getScreenOpeningData(class_3222 serverPlayer) {
                return WaystoneBlockEntityBase.this.getWaystone();
            }

            public class_9139<class_9129, Waystone> getScreenStreamCodec() {
                return WaystoneImpl.STREAM_CODEC;
            }
        });
    }

    public Collection<? extends Waystone> getAuxiliaryTargets() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.container.method_5439(); ++i) {
            class_1799 item = this.container.method_5438(i);
            WaystonesAPI.getBoundWaystone(null, item).ifPresent(result::add);
        }
        return result;
    }

    public class_1263 getContainer() {
        return this.container;
    }

    public void applyModifierEffects(class_1297 entity) {
        int fireSeconds = 0;
        int poisonSeconds = 0;
        int blindSeconds = 0;
        int featherFallSeconds = 0;
        int fireResistanceSeconds = 0;
        int witherSeconds = 0;
        int potency = 1;
        ArrayList<class_1799> curativeItems = new ArrayList<class_1799>();
        for (int i = 0; i < this.container.method_5439(); ++i) {
            class_1799 itemStack = this.container.method_5438(i);
            if (itemStack.method_7909() == class_1802.field_8183) {
                fireSeconds += itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8635) {
                poisonSeconds += itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8794) {
                blindSeconds += itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8103 || itemStack.method_7909() == class_1802.field_21086) {
                curativeItems.add(itemStack);
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8477) {
                potency = Math.min(4, potency + itemStack.method_7947());
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8153) {
                featherFallSeconds = Math.min(8, featherFallSeconds + itemStack.method_7947());
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8135) {
                fireResistanceSeconds = Math.min(8, fireResistanceSeconds + itemStack.method_7947());
                continue;
            }
            if (itemStack.method_7909() != class_1802.field_17515) continue;
            witherSeconds += itemStack.method_7947();
        }
        if (entity instanceof class_1309) {
            if (fireSeconds > 0) {
                entity.method_20803(fireSeconds * 20);
            }
            if (poisonSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5899, poisonSeconds * 20, potency));
            }
            if (blindSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5919, blindSeconds * 20, potency));
            }
            if (featherFallSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5906, featherFallSeconds * 20, potency));
            }
            if (fireResistanceSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5918, fireResistanceSeconds * 20, potency));
            }
            if (witherSeconds > 0) {
                ((class_1309)entity).method_6092(new class_1293(class_1294.field_5920, witherSeconds * 20, potency));
            }
            if (!curativeItems.isEmpty()) {
                ((class_1309)entity).method_6012();
            }
        }
    }

    private int getModifierCount() {
        int modifiers = 0;
        for (int i = 0; i < this.container.method_5439(); ++i) {
            class_1799 itemStack = this.container.method_5438(i);
            if (itemStack.method_7909() == class_1802.field_8183) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8635) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8794) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8103 || itemStack.method_7909() == class_1802.field_21086) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8477) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8153) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8135) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_17515) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8155) {
                ++modifiers;
                continue;
            }
            if (itemStack.method_7909() != class_1802.field_8680) continue;
            ++modifiers;
        }
        return modifiers;
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        super.method_66473(pos, state);
        this.dropItems(this.field_11863, pos);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            Waystone waystone = this.getWaystone();
            boolean wasNotSilkTouched = !this.canSilkTouch() || !this.isSilkTouched();
            WaystoneSyncManager.sendWaystoneRemovalToAll(serverLevel.method_8503(), waystone, wasNotSilkTouched);
            if (wasNotSilkTouched) {
                SavedDataWaystonesStore.get(serverLevel.method_8503()).removeWaystone(waystone);
                PlayerWaystoneManager.removeKnownWaystone(serverLevel.method_8503(), waystone);
            } else if (waystone instanceof MutableWaystone) {
                MutableWaystone mutableWaystone = (MutableWaystone)((Object)waystone);
                mutableWaystone.setTransient(true);
                SavedDataWaystonesStore.get(serverLevel.method_8503()).updateWaystone(waystone);
            }
        }
    }

    protected UUID getEffectiveWaystoneUid() {
        return this.waystone.isValid() ? this.waystone.getWaystoneUid() : this.waystoneUid;
    }
}

