/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.debug.VoicechatUncaughtExceptionHandler;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.MicThread;
import de.maxhenkel.voicechat.voice.client.MicrophoneException;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.speaker.Speaker;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerException;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerManager;
import de.maxhenkel.voicechat.voice.common.AudioUtils;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_11907;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_6382;
import net.minecraft.class_7919;

public class MicTestButton
extends ToggleImageButton
implements ImageButton.TooltipSupplier {
    private static final class_2960 MICROPHONE = class_2960.method_60655((String)"voicechat", (String)"textures/icons/microphone_button.png");
    private static final class_2561 TEST_DISABLED = class_2561.method_43471((String)"message.voicechat.mic_test.disabled");
    private static final class_2561 TEST_ENABLED = class_2561.method_43471((String)"message.voicechat.mic_test.enabled");
    private static final class_2561 TEST_UNAVAILABLE = class_2561.method_43471((String)"message.voicechat.mic_test_unavailable").method_27692(class_124.field_1061);
    private boolean micActive;
    @Nullable
    private VoiceThread voiceThread;
    @Nullable
    private final MicListener micListener;
    private final boolean raw;
    @Nullable
    private final ClientVoicechat client;
    @Nullable
    private State lastState;

    public MicTestButton(int xIn, int yIn, boolean raw, @Nullable MicListener micListener) {
        super(xIn, yIn, MICROPHONE, null, null, null);
        this.raw = raw;
        this.micListener = micListener;
        this.client = ClientManager.getClient();
        this.field_22763 = this.client == null || this.client.getSoundManager() != null;
        this.stateSupplier = () -> !this.micActive;
        this.tooltipSupplier = this;
    }

    public MicTestButton(int xIn, int yIn, boolean raw) {
        this(xIn, yIn, raw, null);
    }

    @Override
    protected void method_75752(class_332 guiGraphics, int mouseX, int mouseY, float f) {
        super.method_75752(guiGraphics, mouseX, mouseY, f);
        this.updateLastRender();
    }

    public void updateLastRender() {
        if (this.voiceThread != null) {
            this.voiceThread.updateLastRender();
        }
    }

    public void setMicActive(boolean micActive) {
        this.micActive = micActive;
    }

    public boolean isMicActive() {
        return this.micActive;
    }

    @Override
    public void method_25306(class_11907 input) {
        this.setMicActive(!this.micActive);
        if (this.micActive) {
            this.close();
            try {
                this.voiceThread = new VoiceThread(e -> {
                    this.setMicActive(false);
                    this.field_22763 = false;
                    Voicechat.LOGGER.error("Microphone error", e);
                });
                this.voiceThread.start();
            }
            catch (Exception e2) {
                this.setMicActive(false);
                this.field_22763 = false;
                Voicechat.LOGGER.error("Microphone error", e2);
            }
        } else {
            this.close();
        }
    }

    private void close() {
        if (this.voiceThread != null) {
            this.voiceThread.close();
            this.voiceThread = null;
        }
    }

    public void stop() {
        this.close();
        this.setMicActive(false);
    }

    @Override
    protected void method_47399(class_6382 narrationElementOutput) {
        this.method_37021(narrationElementOutput);
    }

    @Override
    public void updateTooltip(ImageButton button) {
        State state = this.getState();
        if (state != this.lastState) {
            this.lastState = state;
            button.method_47400(class_7919.method_47407((class_2561)state.getComponent()));
        }
    }

    private State getState() {
        if (!this.field_22763) {
            return State.UNAVAILABLE;
        }
        if (this.micActive) {
            return State.ENABLED;
        }
        return State.DISABLED;
    }

    public static interface MicListener {
        public void onMicValue(double var1);

        public void onStop();
    }

    private class VoiceThread
    extends Thread {
        private final Speaker speaker;
        private boolean running = true;
        private long lastRender;
        private MicThread micThread;
        private boolean usesOwnMicThread;
        @Nullable
        private SoundManager ownSoundManager;

        public VoiceThread(Consumer<MicrophoneException> onMicError) throws SpeakerException {
            SoundManager soundManager;
            this.setDaemon(true);
            this.setName("VoiceTestingThread");
            this.setUncaughtExceptionHandler(new VoicechatUncaughtExceptionHandler());
            MicThread micThread = this.micThread = MicTestButton.this.client != null ? MicTestButton.this.client.getMicThread() : null;
            if (this.micThread == null) {
                this.micThread = new MicThread(MicTestButton.this.client, null, onMicError);
                this.usesOwnMicThread = true;
            } else {
                this.micThread.getError(onMicError);
            }
            if (MicTestButton.this.client == null) {
                this.ownSoundManager = soundManager = SoundManager.create();
            } else {
                soundManager = MicTestButton.this.client.getSoundManager();
            }
            if (soundManager == null) {
                throw new SpeakerException("No sound manager");
            }
            this.speaker = SpeakerManager.createSpeaker(soundManager, null);
            this.updateLastRender();
            this.setMicLocked(true);
        }

        @Override
        public void run() {
            while (this.running && System.currentTimeMillis() - this.lastRender <= 500L && !this.micThread.isClosed()) {
                short[] buff = MicTestButton.this.raw ? this.micThread.pollMic() : this.micThread.pollProcessedAudio(true);
                if (buff == null) continue;
                if (MicTestButton.this.micListener != null) {
                    MicTestButton.this.micListener.onMicValue(AudioUtils.getHighestAudioLevel(buff));
                }
                if (!MicTestButton.this.raw && !this.micThread.shouldTransmitAudio()) continue;
                this.play(buff);
            }
            this.speaker.close();
            this.setMicLocked(false);
            if (MicTestButton.this.micListener != null) {
                MicTestButton.this.micListener.onStop();
            }
            if (this.usesOwnMicThread) {
                this.micThread.close();
            }
            if (this.ownSoundManager != null) {
                this.ownSoundManager.close();
            }
            MicTestButton.this.setMicActive(false);
            Voicechat.LOGGER.info("Mic test audio channel closed", new Object[0]);
        }

        private void play(short[] buff) {
            this.speaker.play(buff, ((Double)VoicechatClient.CLIENT_CONFIG.voiceChatVolume.get()).floatValue(), null);
        }

        public void updateLastRender() {
            this.lastRender = System.currentTimeMillis();
        }

        private void setMicLocked(boolean locked) {
            this.micThread.setMicrophoneLocked(locked);
        }

        public void close() {
            if (!this.running) {
                return;
            }
            Voicechat.LOGGER.info("Stopping mic test audio channel", new Object[0]);
            this.running = false;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Voicechat.LOGGER.warn("Failed to close microphone", e);
            }
        }
    }

    private static enum State {
        ENABLED(TEST_ENABLED),
        DISABLED(TEST_DISABLED),
        UNAVAILABLE(TEST_UNAVAILABLE);

        private final class_2561 component;

        private State(class_2561 component) {
            this.component = component;
        }

        public class_2561 getComponent() {
            return this.component;
        }
    }
}

