/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.command.GroupNameSuggestionProvider;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.permission.Permission;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_12087;
import net.minecraft.class_12094;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5242;

public class VoicechatCommands {
    public static final String VOICECHAT_COMMAND = "voicechat";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder literalBuilder = class_2170.method_9247((String)VOICECHAT_COMMAND);
        literalBuilder.executes(commandSource -> VoicechatCommands.help(dispatcher, (CommandContext<class_2168>)commandSource));
        literalBuilder.then(class_2170.method_9247((String)"help").executes(commandSource -> VoicechatCommands.help(dispatcher, (CommandContext<class_2168>)commandSource)));
        literalBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"test").requires(commandSource -> VoicechatCommands.checkPermission(commandSource, PermissionManager.INSTANCE.ADMIN_PERMISSION))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<class_2168>)commandSource)) {
                return 0;
            }
            class_3222 player = class_2186.method_9315((CommandContext)commandSource, (String)"target");
            Server server = Voicechat.SERVER.getServer();
            if (server == null) {
                ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43471((String)"message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            if (!Voicechat.SERVER.isCompatible(player)) {
                ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43469((String)"message.voicechat.player_no_voicechat", (Object[])new Object[]{player.method_5476(), CommonCompatibilityManager.INSTANCE.getModName()}), false);
                return 1;
            }
            ClientConnection clientConnection = server.getConnections().get(player.method_5667());
            if (clientConnection == null) {
                ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43471((String)"message.voicechat.client_not_connected"), false);
                return 1;
            }
            try {
                ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43471((String)"message.voicechat.sending_ping"), false);
                server.getPingManager().sendPing(clientConnection, 500L, 10, new PingManager.PingListener(){

                    @Override
                    public void onPong(int attempts, long pingMilliseconds) {
                        if (attempts <= 1) {
                            ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43469((String)"message.voicechat.ping_received", (Object[])new Object[]{pingMilliseconds}), false);
                        } else {
                            ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43469((String)"message.voicechat.ping_received_attempt", (Object[])new Object[]{pingMilliseconds, attempts}), false);
                        }
                    }

                    @Override
                    public void onFailedAttempt(int attempts) {
                        ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43471((String)"message.voicechat.ping_retry"), false);
                    }

                    @Override
                    public void onTimeout(int attempts) {
                        ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43469((String)"message.voicechat.ping_timed_out", (Object[])new Object[]{attempts}), false);
                    }
                });
                ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43471((String)"message.voicechat.ping_sent_waiting"), false);
            }
            catch (Exception e) {
                ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43469((String)"message.voicechat.failed_to_send_ping", (Object[])new Object[]{e.getMessage()}), false);
                Voicechat.LOGGER.warn("Failed to send ping", e);
                return 1;
            }
            return 1;
        })));
        literalBuilder.then(class_2170.method_9247((String)"invite").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<class_2168>)commandSource)) {
                return 0;
            }
            class_3222 source = ((class_2168)commandSource.getSource()).method_9207();
            Server server = Voicechat.SERVER.getServer();
            if (server == null) {
                ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43471((String)"message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            PlayerState state = server.getPlayerStateManager().getState(source.method_5667());
            if (state == null || !state.hasGroup()) {
                ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43471((String)"message.voicechat.not_in_group"), false);
                return 1;
            }
            class_3222 player = class_2186.method_9315((CommandContext)commandSource, (String)"target");
            Group group = server.getGroupManager().getGroup(state.getGroup());
            if (group == null) {
                return 1;
            }
            if (!Voicechat.SERVER.isCompatible(player)) {
                ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43469((String)"message.voicechat.player_no_voicechat", (Object[])new Object[]{player.method_5476(), CommonCompatibilityManager.INSTANCE.getModName()}), false);
                return 1;
            }
            String passwordSuffix = group.getPassword() == null ? "" : " \"" + group.getPassword() + "\"";
            player.method_64398((class_2561)class_2561.method_43469((String)"message.voicechat.invite", (Object[])new Object[]{source.method_5476(), class_2561.method_43470((String)group.getName()).method_27692(class_124.field_1080), class_2564.method_10885((class_2561)class_2561.method_43471((String)"message.voicechat.accept_invite").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/voicechat join " + group.getId().toString() + passwordSuffix)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"message.voicechat.accept_invite.hover"))))).method_27692(class_124.field_1060)}));
            ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43469((String)"message.voicechat.invite_successful", (Object[])new Object[]{player.method_5476()}), false);
            return 1;
        })));
        literalBuilder.then(class_2170.method_9247((String)"join").then(class_2170.method_9244((String)"group_id", (ArgumentType)class_5242.method_27643()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<class_2168>)commandSource)) {
                return 0;
            }
            UUID groupID = class_5242.method_27645((CommandContext)commandSource, (String)"group_id");
            return VoicechatCommands.joinGroupById((class_2168)commandSource.getSource(), groupID, null);
        })));
        literalBuilder.then(class_2170.method_9247((String)"join").then(class_2170.method_9244((String)"group_id", (ArgumentType)class_5242.method_27643()).then(class_2170.method_9244((String)"password", (ArgumentType)StringArgumentType.string()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<class_2168>)commandSource)) {
                return 0;
            }
            UUID groupID = class_5242.method_27645((CommandContext)commandSource, (String)"group_id");
            String password = StringArgumentType.getString((CommandContext)commandSource, (String)"password");
            return VoicechatCommands.joinGroupById((class_2168)commandSource.getSource(), groupID, password.isEmpty() ? null : password);
        }))));
        literalBuilder.then(class_2170.method_9247((String)"join").then(class_2170.method_9244((String)"group_name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)GroupNameSuggestionProvider.INSTANCE).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<class_2168>)commandSource)) {
                return 0;
            }
            String groupName = StringArgumentType.getString((CommandContext)commandSource, (String)"group_name");
            return VoicechatCommands.joinGroupByName((class_2168)commandSource.getSource(), groupName, null);
        })));
        literalBuilder.then(class_2170.method_9247((String)"join").then(class_2170.method_9244((String)"group_name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)GroupNameSuggestionProvider.INSTANCE).then(class_2170.method_9244((String)"password", (ArgumentType)StringArgumentType.string()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<class_2168>)commandSource)) {
                return 0;
            }
            String groupName = StringArgumentType.getString((CommandContext)commandSource, (String)"group_name");
            String password = StringArgumentType.getString((CommandContext)commandSource, (String)"password");
            return VoicechatCommands.joinGroupByName((class_2168)commandSource.getSource(), groupName, password.isEmpty() ? null : password);
        }))));
        literalBuilder.then(class_2170.method_9247((String)"leave").executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<class_2168>)commandSource)) {
                return 0;
            }
            if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
                ((class_2168)commandSource.getSource()).method_9213((class_2561)class_2561.method_43471((String)"message.voicechat.groups_disabled"));
                return 1;
            }
            Server server = Voicechat.SERVER.getServer();
            if (server == null) {
                ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43471((String)"message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            class_3222 source = ((class_2168)commandSource.getSource()).method_9207();
            PlayerState state = server.getPlayerStateManager().getState(source.method_5667());
            if (state == null || !state.hasGroup()) {
                ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43471((String)"message.voicechat.not_in_group"), false);
                return 1;
            }
            server.getGroupManager().leaveGroup(source);
            ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43471((String)"message.voicechat.leave_successful"), false);
            return 1;
        }));
        dispatcher.register(literalBuilder);
    }

    private static Server joinGroup(class_2168 source) throws CommandSyntaxException {
        if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
            source.method_9213((class_2561)class_2561.method_43471((String)"message.voicechat.groups_disabled"));
            return null;
        }
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            source.method_9226(() -> class_2561.method_43471((String)"message.voicechat.voice_chat_unavailable"), false);
            return null;
        }
        class_3222 player = source.method_9207();
        if (!PermissionManager.INSTANCE.GROUPS_PERMISSION.hasPermission(player)) {
            source.method_9226(() -> class_2561.method_43471((String)"message.voicechat.no_group_permission"), false);
            return null;
        }
        return server;
    }

    private static int joinGroupByName(class_2168 source, String groupName, @Nullable String password) throws CommandSyntaxException {
        Server server = VoicechatCommands.joinGroup(source);
        if (server == null) {
            return 1;
        }
        List groups = server.getGroupManager().getGroups().values().stream().filter(group -> group.getName().equals(groupName)).collect(Collectors.toList());
        if (groups.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43471((String)"message.voicechat.group_does_not_exist"));
            return 1;
        }
        if (groups.size() > 1) {
            source.method_9213((class_2561)class_2561.method_43471((String)"message.voicechat.group_name_not_unique"));
            return 1;
        }
        return VoicechatCommands.joinGroup(source, server, ((Group)groups.get(0)).getId(), password);
    }

    private static int joinGroupById(class_2168 source, UUID groupID, @Nullable String password) throws CommandSyntaxException {
        Server server = VoicechatCommands.joinGroup(source);
        if (server == null) {
            return 1;
        }
        return VoicechatCommands.joinGroup(source, server, groupID, password);
    }

    private static int joinGroup(class_2168 source, Server server, UUID groupID, @Nullable String password) throws CommandSyntaxException {
        Group group = server.getGroupManager().getGroup(groupID);
        if (group == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"message.voicechat.group_does_not_exist"));
            return 1;
        }
        server.getGroupManager().joinGroup(group, source.method_9207(), password);
        source.method_9226(() -> class_2561.method_43469((String)"message.voicechat.join_successful", (Object[])new Object[]{class_2561.method_43470((String)group.getName()).method_27692(class_124.field_1080)}), false);
        return 1;
    }

    private static int help(CommandDispatcher<class_2168> dispatcher, CommandContext<class_2168> commandSource) {
        if (VoicechatCommands.checkNoVoicechat(commandSource)) {
            return 0;
        }
        CommandNode voicechatCommand = dispatcher.getRoot().getChild(VOICECHAT_COMMAND);
        Map map = dispatcher.getSmartUsage(voicechatCommand, (Object)((class_2168)commandSource.getSource()));
        for (Map.Entry entry : map.entrySet()) {
            ((class_2168)commandSource.getSource()).method_9226(() -> class_2561.method_43470((String)"/%s %s".formatted(VOICECHAT_COMMAND, entry.getValue())), false);
        }
        return map.size();
    }

    private static boolean checkNoVoicechat(CommandContext<class_2168> commandSource) {
        try {
            class_3222 player = ((class_2168)commandSource.getSource()).method_9207();
            if (Voicechat.SERVER.isCompatible(player)) {
                return false;
            }
            ((class_2168)commandSource.getSource()).method_9213((class_2561)class_2561.method_43470((String)Voicechat.TRANSLATIONS.voicechatNeededForCommandMessage.get().formatted(CommonCompatibilityManager.INSTANCE.getModName())));
            return true;
        }
        catch (Exception e) {
            ((class_2168)commandSource.getSource()).method_9213((class_2561)class_2561.method_43470((String)Voicechat.TRANSLATIONS.playerCommandMessage.get()));
            return true;
        }
    }

    private static boolean checkPermission(class_2168 stack, Permission permission) {
        try {
            return permission.hasPermission(stack.method_9207());
        }
        catch (CommandSyntaxException e) {
            return stack.method_75037().hasPermission((class_12087)new class_12087.class_12089(class_12094.field_63199));
        }
    }
}

