/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3288;
import net.minecraft.class_7367;
import net.minecraft.class_7677;
import net.xstopho.resourcelibrary.LibConstants;

public class ResourcePackUtils {
    private static final class_310 client = class_310.method_1551();

    public static <T> LinkedList<T> readAllMetaData(class_7677<T> metadataSectionType) {
        LinkedList<Object> allMetaData = new LinkedList<Object>();
        for (class_3288 pack : client.method_1520().method_14444()) {
            try {
                class_3262 resources = pack.method_14458();
                try {
                    Object metadataSection = resources.method_14407(metadataSectionType);
                    if (metadataSection == null) continue;
                    allMetaData.add(metadataSection);
                }
                finally {
                    if (resources == null) continue;
                    resources.close();
                }
            }
            catch (IOException e) {
                LibConstants.LOG.error("Error reading pack.mcmeta", (Throwable)e);
            }
        }
        return allMetaData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readMetaData(class_7677<T> metadataSectionType) {
        Iterator iterator = client.method_1520().method_14444().iterator();
        while (iterator.hasNext()) {
            class_3288 pack = (class_3288)iterator.next();
            try {
                class_3262 resources = pack.method_14458();
                try {
                    Object metadataSection = resources.method_14407(metadataSectionType);
                    if (metadataSection == null) continue;
                    Object object = metadataSection;
                    return (T)object;
                }
                finally {
                    if (resources == null) continue;
                    resources.close();
                }
            }
            catch (IOException e) {
                LibConstants.LOG.error("Error reading pack.mcmeta", (Throwable)e);
            }
        }
        return null;
    }

    public static LinkedList<JsonObject> readAllMetaData(String object) {
        LinkedList<JsonObject> allMetaData = new LinkedList<JsonObject>();
        for (class_3288 pack : client.method_1520().method_14444()) {
            try {
                class_3262 resources = pack.method_14458();
                try {
                    class_7367 ioSup = resources.method_14410(new String[]{"pack.mcmeta"});
                    if (ioSup == null) continue;
                    InputStream metaStream = (InputStream)ioSup.get();
                    try {
                        String json = new String(metaStream.readAllBytes(), StandardCharsets.UTF_8);
                        JsonObject meta = JsonParser.parseString((String)json).getAsJsonObject();
                        if (!meta.has(object) || !meta.get(object).isJsonObject()) continue;
                        allMetaData.add(meta.getAsJsonObject(object));
                    }
                    finally {
                        if (metaStream == null) continue;
                        metaStream.close();
                    }
                }
                finally {
                    if (resources == null) continue;
                    resources.close();
                }
            }
            catch (IOException e) {
                LibConstants.LOG.error("Error reading pack.mcmeta", (Throwable)e);
            }
        }
        return allMetaData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject readMetaData(String object) {
        Iterator iterator = client.method_1520().method_14444().iterator();
        while (iterator.hasNext()) {
            class_3288 pack = (class_3288)iterator.next();
            try {
                class_3262 resources = pack.method_14458();
                try {
                    class_7367 ioSup = resources.method_14410(new String[]{"pack.mcmeta"});
                    if (ioSup == null) continue;
                    InputStream metaStream = (InputStream)ioSup.get();
                    try {
                        String json = new String(metaStream.readAllBytes(), StandardCharsets.UTF_8);
                        JsonObject meta = JsonParser.parseString((String)json).getAsJsonObject();
                        if (!meta.has(object) || !meta.get(object).isJsonObject()) continue;
                        JsonObject jsonObject = meta.getAsJsonObject(object);
                        return jsonObject;
                    }
                    finally {
                        if (metaStream == null) continue;
                        metaStream.close();
                    }
                }
                finally {
                    if (resources == null) continue;
                    resources.close();
                }
            }
            catch (IOException e) {
                LibConstants.LOG.error("Error reading pack.mcmeta", (Throwable)e);
            }
        }
        return null;
    }
}

