/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.runtime.internal;

import java.util.function.Consumer;
import net.blay09.mods.balm.commands.BalmCommands;
import net.blay09.mods.balm.core.BalmRegistrar;
import net.blay09.mods.balm.core.BalmRegistrars;
import net.blay09.mods.balm.core.component.BalmDataComponentTypeRegistrar;
import net.blay09.mods.balm.core.particles.BalmParticleTypeRegistrar;
import net.blay09.mods.balm.network.BalmNetworking;
import net.blay09.mods.balm.platform.BalmHooks;
import net.blay09.mods.balm.platform.BalmPlatform;
import net.blay09.mods.balm.platform.BalmSafeClientAccess;
import net.blay09.mods.balm.platform.ModProxy;
import net.blay09.mods.balm.platform.PlatformProxy;
import net.blay09.mods.balm.platform.SidedProxy;
import net.blay09.mods.balm.platform.attachment.BalmDataAttachmentTypeRegistrar;
import net.blay09.mods.balm.platform.capabilities.BalmCapabilities;
import net.blay09.mods.balm.platform.compatibility.BalmModSupport;
import net.blay09.mods.balm.platform.config.BalmConfig;
import net.blay09.mods.balm.platform.event.BidirectionalEventMapper;
import net.blay09.mods.balm.platform.module.BalmModule;
import net.blay09.mods.balm.platform.permissions.BalmPermissions;
import net.blay09.mods.balm.platform.runtime.BalmRuntimeLoadContext;
import net.blay09.mods.balm.server.packs.resources.BalmResourceConditionRegistrar;
import net.blay09.mods.balm.server.packs.resources.BalmResourceReloadListenerRegistrar;
import net.blay09.mods.balm.stats.BalmCustomStatRegistrar;
import net.blay09.mods.balm.world.entity.BalmEntityTypeRegistrar;
import net.blay09.mods.balm.world.entity.ai.village.poi.BalmPoiTypeRegistrar;
import net.blay09.mods.balm.world.inventory.BalmMenuTypeRegistrar;
import net.blay09.mods.balm.world.item.BalmCreativeModeTabRegistrar;
import net.blay09.mods.balm.world.item.BalmItemRegistrar;
import net.blay09.mods.balm.world.item.crafting.BalmRecipeTypeRegistrar;
import net.blay09.mods.balm.world.level.block.BalmBlockRegistrar;
import net.blay09.mods.balm.world.level.block.entity.BalmBlockEntityTypeRegistrar;
import net.blay09.mods.balm.world.level.levelgen.BalmWorldGen;
import net.blay09.mods.balm.world.level.storage.loot.BalmLootTables;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public interface BalmRuntime<TLoadContext extends BalmRuntimeLoadContext> {
    public BalmConfig getConfig();

    public BalmWorldGen getWorldGen();

    public void menuTypes(String var1, Consumer<BalmMenuTypeRegistrar> var2);

    public BalmNetworking getNetworking();

    public BalmHooks getHooks();

    public void entityTypes(String var1, Consumer<BalmEntityTypeRegistrar> var2);

    public BalmCapabilities getCapabilities();

    public BalmCommands getCommands();

    public BalmLootTables getLootTables();

    public BalmModSupport getModSupport();

    public void particleTypes(String var1, Consumer<BalmParticleTypeRegistrar> var2);

    public void customStats(String var1, Consumer<BalmCustomStatRegistrar> var2);

    public BalmPermissions getPermissions();

    public <TProxy> SidedProxy<TProxy> sidedProxy(String var1, String var2);

    public void initializeMod(String var1, TLoadContext var2, Consumer<BalmRegistrars> var3);

    public void initializeIfLoaded(String var1, String var2);

    public <T> PlatformProxy<T> platformProxy();

    public <T> ModProxy<T> modProxy();

    default public void initializeModule(BalmModule module) {
        String modId = module.getId().method_12836();
        module.registerConfig(this.getConfig());
        this.resourceConditions(modId, module::registerResourceConditions);
        this.dataAttachmentTypes(modId, module::registerDataAttachmentTypes);
        this.dataComponentTypes(modId, module::registerDataComponentTypes);
        this.blocks(modId, module::registerBlocks);
        this.blockEntityTypes(modId, module::registerBlockEntityTypes);
        this.items(modId, module::registerItems);
        this.creativeModeTabs(modId, module::registerCreativeModeTabs);
        this.entityTypes(modId, module::registerEntityTypes);
        module.registerWorldGen(this.getWorldGen());
        this.poiTypes(modId, module::registerPoiTypes);
        module.registerNetworking(this.getNetworking());
        this.menuTypes(modId, module::registerMenuTypes);
        module.registerCapabilities(this.getCapabilities());
        module.registerCommands(this.getCommands());
        this.recipeTypes(modId, module::registerRecipeTypes);
        module.registerLootTables(this.getLootTables());
        this.customStats(modId, module::registerCustomStats);
        module.registerSoundEvents(this.registrar().scoped(class_7924.field_41225, modId));
        module.registerPermissions(this.getPermissions());
        this.particleTypes(modId, module::registerParticleTypes);
        module.registerAdditional(this.registrar());
        this.resourceReloadListeners(modId, module::registerReloadListeners);
        module.initialize();
    }

    public BalmSafeClientAccess getProxy();

    public boolean isReady();

    public void onRuntimeAvailable(Runnable var1);

    public void registerModule(BalmRegistrars var1, BalmModule var2);

    public BalmRegistrar registrar();

    default public <T> BalmRegistrar.Scoped<T> registrar(class_5321<? extends class_2378<T>> registryKey, String namespace) {
        return this.registrar().scoped(registryKey, namespace);
    }

    public void blocks(String var1, Consumer<BalmBlockRegistrar> var2);

    public void items(String var1, Consumer<BalmItemRegistrar> var2);

    public void recipeTypes(String var1, Consumer<BalmRecipeTypeRegistrar> var2);

    public void dataComponentTypes(String var1, Consumer<BalmDataComponentTypeRegistrar> var2);

    public void dataAttachmentTypes(String var1, Consumer<BalmDataAttachmentTypeRegistrar> var2);

    public void poiTypes(String var1, Consumer<BalmPoiTypeRegistrar> var2);

    public void creativeModeTabs(String var1, Consumer<BalmCreativeModeTabRegistrar> var2);

    public void blockEntityTypes(String var1, Consumer<BalmBlockEntityTypeRegistrar> var2);

    public BalmPlatform platform();

    public void resourceReloadListeners(String var1, Consumer<BalmResourceReloadListenerRegistrar> var2);

    public void resourceConditions(String var1, Consumer<BalmResourceConditionRegistrar> var2);

    public <TEvent> BidirectionalEventMapper<Consumer<TEvent>> createBoundCustomEvent(Class<TEvent> var1);
}

