/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.config.schema.internal;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.balm.platform.config.LoadedConfig;
import net.blay09.mods.balm.platform.config.internal.DefaultedConfig;
import net.blay09.mods.balm.platform.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.platform.config.schema.ConfigSchemaBuilder;
import net.blay09.mods.balm.platform.config.schema.ConfiguredProperty;
import net.blay09.mods.balm.platform.config.schema.builder.ConfigCategory;
import net.blay09.mods.balm.platform.config.schema.builder.ConfigCategoryBuilder;
import net.blay09.mods.balm.platform.config.schema.builder.ConfigPropertyBuilder;
import net.blay09.mods.balm.platform.config.schema.internal.ConfigCategoryImpl;
import net.minecraft.class_2960;
import org.jspecify.annotations.Nullable;

public class ConfigSchemaImpl
implements BalmConfigSchema,
ConfigSchemaBuilder {
    private final class_2960 identifier;
    private final Map<String, ConfigCategory> categories = new HashMap<String, ConfigCategory>();
    private final Map<String, ConfiguredProperty<?>> rootProperties = new HashMap();
    private final Table<String, String, ConfiguredProperty<?>> properties = HashBasedTable.create();

    public ConfigSchemaImpl(class_2960 identifier) {
        this.identifier = identifier;
    }

    @Override
    public class_2960 identifier() {
        return this.identifier;
    }

    @Override
    public ConfigPropertyBuilder property(String name) {
        return new ConfigPropertyBuilder(this, name);
    }

    @Override
    public ConfigCategoryBuilder category(String name) {
        ConfigCategoryImpl category = new ConfigCategoryImpl(this, name);
        this.categories.put(name, category);
        return category;
    }

    @Override
    public LoadedConfig defaults() {
        return DefaultedConfig.INSTANCE;
    }

    @Override
    public Collection<ConfiguredProperty<?>> rootProperties() {
        return this.rootProperties.values();
    }

    @Override
    public Collection<ConfigCategory> categories() {
        return this.categories.values();
    }

    @Override
    public @Nullable ConfiguredProperty<?> findProperty(String category, String property) {
        return (ConfiguredProperty)this.properties.get((Object)category, (Object)property);
    }

    @Override
    public @Nullable ConfiguredProperty<?> findRootProperty(String property) {
        return (ConfiguredProperty)this.properties.get((Object)"", (Object)property);
    }

    public <T extends ConfiguredProperty<?>> T addAndReturn(T property) {
        this.properties.put((Object)property.category(), (Object)property.name(), property);
        if (property.category().isEmpty()) {
            this.rootProperties.put(property.name(), property);
        } else {
            ConfigCategory configCategory = this.categories.get(property.category());
            if (configCategory instanceof ConfigCategoryImpl) {
                ConfigCategoryImpl category = (ConfigCategoryImpl)configCategory;
                category.addProperty(property);
            }
        }
        return property;
    }
}

