/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.config.internal;

import java.util.Collection;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.network.BalmNetworking;
import net.blay09.mods.balm.network.protocol.common.custom.internal.ClientboundConfigPacket;
import net.blay09.mods.balm.platform.config.LoadedConfig;
import net.blay09.mods.balm.platform.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.platform.config.schema.ConfiguredProperty;
import net.blay09.mods.balm.platform.config.schema.builder.ConfigCategory;
import net.blay09.mods.balm.platform.event.callback.ConfigCallback;
import net.blay09.mods.balm.platform.event.callback.ServerPlayerCallback;
import net.blay09.mods.balm.platform.module.BalmModule;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;

public class ConfigSync
implements BalmModule {
    public static boolean hasImplicitSync(BalmConfigSchema schema) {
        return schema.identifier().method_12832().equals("server");
    }

    public static boolean hasSyncedProperties(BalmConfigSchema schema) {
        return ConfigSync.hasImplicitSync(schema) || schema.rootProperties().stream().anyMatch(ConfiguredProperty::synced) || schema.categories().stream().anyMatch(ConfigSync::hasSyncedProperties);
    }

    public static boolean hasSyncedProperties(ConfigCategory category) {
        return category.properties().stream().anyMatch(ConfiguredProperty::synced);
    }

    @Override
    public class_2960 getId() {
        return class_2960.method_60655((String)"balm", (String)"config_sync");
    }

    @Override
    public void registerNetworking(BalmNetworking networking) {
        networking.registerClientboundPacket(ClientboundConfigPacket.TYPE, ClientboundConfigPacket.class, ClientboundConfigPacket.STREAM_CODEC, ClientboundConfigPacket::handle);
    }

    @Override
    public void initialize() {
        ServerPlayerCallback.Join.EVENT.register(player -> {
            Collection<BalmConfigSchema> schemas = Balm.config().getSchemas();
            for (BalmConfigSchema schema : schemas) {
                LoadedConfig loaded;
                if (!ConfigSync.hasSyncedProperties(schema) || (loaded = Balm.config().getActiveConfig(schema)) == null) continue;
                ClientboundConfigPacket packet = new ClientboundConfigPacket(schema, loaded);
                Balm.networking().sendTo((class_1657)player, packet);
            }
        });
        ConfigCallback.Reloaded.EVENT.register(schema -> {
            LoadedConfig loaded;
            MinecraftServer server = Balm.platform().server();
            if (server != null && ConfigSync.hasSyncedProperties(schema) && (loaded = Balm.config().getActiveConfig(schema)) != null) {
                ClientboundConfigPacket packet = new ClientboundConfigPacket(schema, loaded);
                Balm.networking().sendToAll(server, packet);
            }
        });
    }

    public static boolean isSyncedProperty(ConfiguredProperty<?> configuredProperty) {
        return ConfigSync.hasImplicitSync(configuredProperty.parentSchema()) || configuredProperty.synced();
    }
}

