/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.world.level.block.entity.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.blay09.mods.balm.world.level.block.entity.OnLoadHandler;
import net.minecraft.class_1937;
import net.minecraft.class_2586;

public class BlockEntityOnLoadCallback {
    private static final Map<class_1937, LevelScope> levelBlockEntities = new WeakHashMap<class_1937, LevelScope>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleOnLoad(class_1937 level, Collection<class_2586> blockEntities) {
        Map<class_1937, LevelScope> map = levelBlockEntities;
        synchronized (map) {
            LevelScope scope = levelBlockEntities.computeIfAbsent(level, key -> new LevelScope());
            if (scope.onLoadRunning) {
                scope.pendingFreshBlockEntities.addAll(blockEntities);
            } else {
                scope.freshBlockEntities.addAll(blockEntities);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireOnLoad(class_1937 level) {
        Map<class_1937, LevelScope> map = levelBlockEntities;
        synchronized (map) {
            LevelScope scope = levelBlockEntities.computeIfAbsent(level, key -> new LevelScope());
            scope.freshBlockEntities.addAll(scope.pendingFreshBlockEntities);
            scope.pendingFreshBlockEntities.clear();
            scope.onLoadRunning = true;
            for (class_2586 blockEntity : scope.freshBlockEntities) {
                if (!(blockEntity instanceof OnLoadHandler)) continue;
                OnLoadHandler handler = (OnLoadHandler)blockEntity;
                handler.onLoad();
            }
            scope.freshBlockEntities.clear();
            scope.onLoadRunning = false;
        }
    }

    private static class LevelScope {
        private final List<class_2586> pendingFreshBlockEntities = new ArrayList<class_2586>();
        private final List<class_2586> freshBlockEntities = new ArrayList<class_2586>();
        private boolean onLoadRunning;

        private LevelScope() {
        }
    }
}

