/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm;

import java.util.function.Consumer;
import net.blay09.mods.balm.commands.BalmCommands;
import net.blay09.mods.balm.core.BalmRegistrars;
import net.blay09.mods.balm.network.BalmNetworking;
import net.blay09.mods.balm.platform.BalmHooks;
import net.blay09.mods.balm.platform.BalmPlatform;
import net.blay09.mods.balm.platform.BalmSafeClientAccess;
import net.blay09.mods.balm.platform.ModProxy;
import net.blay09.mods.balm.platform.PlatformProxy;
import net.blay09.mods.balm.platform.SidedProxy;
import net.blay09.mods.balm.platform.capabilities.BalmCapabilities;
import net.blay09.mods.balm.platform.compatibility.BalmModSupport;
import net.blay09.mods.balm.platform.config.BalmConfig;
import net.blay09.mods.balm.platform.module.BalmModule;
import net.blay09.mods.balm.platform.permissions.BalmPermissions;
import net.blay09.mods.balm.platform.runtime.BalmRuntimeLoadContext;
import net.blay09.mods.balm.platform.runtime.internal.BalmRuntime;
import net.blay09.mods.balm.platform.runtime.internal.BalmRuntimeSpi;
import net.blay09.mods.balm.world.level.levelgen.BalmWorldGen;
import net.blay09.mods.balm.world.level.storage.loot.BalmLootTables;

public class Balm {
    private static final BalmRuntime<BalmRuntimeLoadContext> runtime = BalmRuntimeSpi.create();

    public static void initializeMod(String modId, BalmRuntimeLoadContext context, Consumer<BalmRegistrars> initializer) {
        runtime.initializeMod(modId, context, initializer);
    }

    public static <T extends BalmRuntimeLoadContext> void initializeMod(String modId, T context, BalmModule module) {
        runtime.initializeMod(modId, context, registrars -> registrars.registerModule(module));
    }

    public static <T extends BalmRuntimeLoadContext> void initializeMod(String modId, T context, BalmModule ... modules) {
        runtime.initializeMod(modId, context, registrars -> {
            for (BalmModule module : modules) {
                registrars.registerModule(module);
            }
        });
    }

    public static <T> PlatformProxy<T> platformProxy() {
        return runtime.platformProxy();
    }

    public static <T> ModProxy<T> modProxy() {
        return runtime.modProxy();
    }

    public static <T> SidedProxy<T> sidedProxy(String commonName, String clientName) {
        return runtime.sidedProxy(commonName, clientName);
    }

    public static void initializeIfLoaded(String modId, String className) {
        runtime.initializeIfLoaded(modId, className);
    }

    public static BalmSafeClientAccess safeClientAccess() {
        return runtime.getProxy();
    }

    public static BalmConfig config() {
        return runtime.getConfig();
    }

    public static BalmNetworking networking() {
        return runtime.getNetworking();
    }

    public static BalmWorldGen biomeModifications() {
        return runtime.getWorldGen();
    }

    public static BalmHooks hooks() {
        return runtime.getHooks();
    }

    public static BalmCapabilities capabilities() {
        return runtime.getCapabilities();
    }

    public static BalmCommands commands() {
        return runtime.getCommands();
    }

    public static BalmLootTables lootModifiers() {
        return runtime.getLootTables();
    }

    public static BalmModSupport modSupport() {
        return runtime.getModSupport();
    }

    public static BalmPermissions permissions() {
        return runtime.getPermissions();
    }

    public static BalmRuntime<? extends BalmRuntimeLoadContext> getRuntime() {
        return runtime;
    }

    public static BalmPlatform platform() {
        return runtime.platform();
    }
}

