/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.server.data.PlayerData;

public class ServerData
extends class_18 {
    private final Map<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();

    private ServerData() {
    }

    private static ServerData read(class_2487 tag) {
        ServerData playersData = new ServerData();
        class_2487 playersNbt = tag.method_68568("players");
        playersNbt.method_10541().forEach(key -> playersData.players.put(UUID.fromString(key), PlayerData.read(playersNbt.method_68568(key))));
        return playersData;
    }

    private class_2487 writeNbt(class_2487 nbt) {
        class_2487 playersNbt = new class_2487();
        for (Map.Entry<UUID, PlayerData> entry : this.players.entrySet()) {
            playersNbt.method_10566(entry.getKey().toString(), (class_2520)entry.getValue().writeNbt(new class_2487()));
        }
        nbt.method_10566("players", (class_2520)playersNbt);
        return nbt;
    }

    public static class_10741<ServerData> getPersistentStateType() {
        return new class_10741("puffish_skills", ServerData::new, (Codec)new Codec<ServerData>(){

            public <T> DataResult<Pair<ServerData, T>> decode(DynamicOps<T> ops, T input) {
                return DataResult.success((Object)Pair.of((Object)((Object)ServerData.read((class_2487)input)), input));
            }

            public <T> DataResult<T> encode(ServerData input, DynamicOps<T> ops, T prefix) {
                if (!(prefix instanceof class_2491)) {
                    throw new RuntimeException();
                }
                return DataResult.success((Object)input.writeNbt(new class_2487()));
            }
        }, null);
    }

    public static ServerData getOrCreate(MinecraftServer server) {
        class_26 persistentStateManager = server.method_30002().method_17983();
        return (ServerData)persistentStateManager.method_17924(ServerData.getPersistentStateType());
    }

    public PlayerData getPlayerData(class_3222 player) {
        return this.players.computeIfAbsent(player.method_5667(), uuid -> PlayerData.empty());
    }

    public void putPlayerData(class_3222 player, PlayerData data) {
        this.players.put(player.method_5667(), data);
    }

    public boolean method_79() {
        return true;
    }
}

