/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl.json;

import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.puffish.skillsmod.api.json.JsonArray;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public class JsonObjectTrackingImpl
implements net.puffish.skillsmod.api.json.JsonObject {
    private final Set<String> usedKeys = new HashSet<String>();
    private final net.puffish.skillsmod.api.json.JsonObject parent;

    public JsonObjectTrackingImpl(net.puffish.skillsmod.api.json.JsonObject parent) {
        this.parent = parent;
    }

    public List<Problem> reportUnusedEntries() {
        return this.parent.stream().filter(entry -> !this.usedKeys.contains(entry.getKey())).map(entry -> this.parent.getPath().createProblem("Unused field `" + (String)entry.getKey() + "`")).toList();
    }

    @Override
    public Result<JsonElement, Problem> get(String key) {
        this.usedKeys.add(key);
        return this.parent.get(key);
    }

    @Override
    public Result<net.puffish.skillsmod.api.json.JsonObject, Problem> getObject(String key) {
        this.usedKeys.add(key);
        return this.parent.getObject(key);
    }

    @Override
    public Result<JsonArray, Problem> getArray(String key) {
        this.usedKeys.add(key);
        return this.parent.getArray(key);
    }

    @Override
    public Result<String, Problem> getString(String key) {
        this.usedKeys.add(key);
        return this.parent.getString(key);
    }

    @Override
    public Result<Float, Problem> getFloat(String key) {
        this.usedKeys.add(key);
        return this.parent.getFloat(key);
    }

    @Override
    public Result<Double, Problem> getDouble(String key) {
        this.usedKeys.add(key);
        return this.parent.getDouble(key);
    }

    @Override
    public Result<Integer, Problem> getInt(String key) {
        this.usedKeys.add(key);
        return this.parent.getInt(key);
    }

    @Override
    public Result<Boolean, Problem> getBoolean(String key) {
        this.usedKeys.add(key);
        return this.parent.getBoolean(key);
    }

    @Override
    public Stream<Map.Entry<String, JsonElement>> stream() {
        return this.parent.stream();
    }

    @Override
    public JsonElement getAsElement() {
        return this.parent.getAsElement();
    }

    @Override
    public <S, F> Result<Map<String, S>, Map<String, F>> getAsMap(BiFunction<String, JsonElement, Result<S, F>> function) {
        return this.parent.getAsMap(function);
    }

    @Override
    public <S> Result<S, Problem> noUnused(Function<net.puffish.skillsmod.api.json.JsonObject, Result<S, Problem>> function) {
        return this.parent.noUnused(function);
    }

    @Override
    public JsonPath getPath() {
        return this.parent.getPath();
    }

    @Override
    public JsonObject getJson() {
        return this.parent.getJson();
    }
}

