/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_189;
import net.minecraft.class_2960;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface FrameConfig {
    public static FrameConfig createDefault() {
        return new AdvancementFrameConfig(class_189.field_1254);
    }

    public static Result<FrameConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().flatMap(LegacyUtils.wrapNoUnused(rootObject -> FrameConfig.parse(rootObject, context), context), failure -> BuiltinJson.parseFrame(rootElement).mapSuccess(AdvancementFrameConfig::new));
    }

    public static Result<FrameConfig, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<JsonElement> optTypeElement = rootObject.get("type").ifFailure(problems::add).getSuccess();
        Optional optType = optTypeElement.flatMap(typeElement -> typeElement.getAsString().ifFailure(problems::add).getSuccess());
        Optional<JsonElement> optData = rootObject.get("data").ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return FrameConfig.build((String)optType.orElseThrow(), optData.orElseThrow(), optTypeElement.orElseThrow().getPath(), context);
        }
        return Result.failure(Problem.combine(problems));
    }

    private static Result<FrameConfig, Problem> build(String type, JsonElement dataElement, JsonPath typeElementPath, ConfigContext context) {
        return switch (type) {
            case "advancement" -> AdvancementFrameConfig.parse(dataElement, context).mapSuccess(Function.identity());
            case "texture" -> TextureFrameConfig.parse(dataElement, context).mapSuccess(Function.identity());
            default -> Result.failure(typeElementPath.createProblem("Expected a valid icon type"));
        };
    }

    public record AdvancementFrameConfig(class_189 frame) implements FrameConfig
    {
        public static Result<AdvancementFrameConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
            return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(AdvancementFrameConfig::parse, context));
        }

        public static Result<AdvancementFrameConfig, Problem> parse(JsonObject rootObject) {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            Optional optEffect = rootObject.get("frame").andThen(BuiltinJson::parseFrame).ifFailure(problems::add).getSuccess();
            if (problems.isEmpty()) {
                return Result.success(new AdvancementFrameConfig((class_189)optEffect.orElseThrow()));
            }
            return Result.failure(Problem.combine(problems));
        }
    }

    public record TextureFrameConfig(Optional<class_2960> lockedTexture, class_2960 availableTexture, Optional<class_2960> affordableTexture, class_2960 unlockedTexture, Optional<class_2960> excludedTexture) implements FrameConfig
    {
        public static Result<TextureFrameConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
            return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(TextureFrameConfig::parse, context));
        }

        private static Result<TextureFrameConfig, Problem> parse(JsonObject rootObject) {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            Optional<class_2960> optAffordableTexture = rootObject.get("affordable").getSuccess().flatMap(element -> BuiltinJson.parseIdentifier(element).ifFailure(problems::add).getSuccess());
            Optional optAvailableTexture = rootObject.get("available").andThen(BuiltinJson::parseIdentifier).ifFailure(problems::add).getSuccess();
            Optional<class_2960> optLockedTexture = rootObject.get("locked").getSuccess().flatMap(element -> BuiltinJson.parseIdentifier(element).ifFailure(problems::add).getSuccess());
            Optional optUnlockedTexture = rootObject.get("unlocked").andThen(BuiltinJson::parseIdentifier).ifFailure(problems::add).getSuccess();
            Optional<class_2960> optExcludedTexture = rootObject.get("excluded").getSuccess().flatMap(element -> BuiltinJson.parseIdentifier(element).ifFailure(problems::add).getSuccess());
            if (problems.isEmpty()) {
                return Result.success(new TextureFrameConfig(optLockedTexture, (class_2960)optAvailableTexture.orElseThrow(), optAffordableTexture, (class_2960)optUnlockedTexture.orElseThrow(), optExcludedTexture));
            }
            return Result.failure(Problem.combine(problems));
        }
    }
}

