/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.TextureFormat;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1061;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_7764;
import net.minecraft.class_8684;
import net.minecraft.class_8689;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.common.BackgroundPosition;
import org.apache.commons.lang3.RandomStringUtils;
import org.lwjgl.system.MemoryUtil;

public record ClientBackgroundConfig(class_2960 texture, int width, int height, BackgroundPosition position) {
    public static ClientBackgroundConfig create(class_2960 textureId, int width, int height, BackgroundPosition position) {
        class_2960 id = SkillsMod.createIdentifier(RandomStringUtils.insecure().next(16, "abcdefghijklmnopqrstuvwxyz0123456789"));
        class_310 client = class_310.method_1551();
        client.execute(() -> client.method_1531().method_4616(id, (class_1044)new ClientBackgroundTexture(textureId)));
        return new ClientBackgroundConfig(id, width, height, position);
    }

    private static class ClientBackgroundTexture
    extends class_1044
    implements class_1061 {
        private final class_7764 contents;
        private final class_7764.class_12298 animator;
        private final GpuBuffer gpuBuffer;

        public ClientBackgroundTexture(class_2960 id) {
            this.field_63613 = RenderSystem.getSamplerCache().method_75297(FilterMode.NEAREST);
            this.contents = class_310.method_1551().method_1478().method_14486(id).flatMap(resource -> Optional.ofNullable(class_8684.create(Set.of(class_8689.field_45647)).loadSprite(id, resource))).orElseGet(class_1047::method_45805);
            int size = class_3532.method_28139((int)class_7764.field_64235, (int)RenderSystem.getDevice().getUniformOffsetAlignment());
            ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)size);
            ClientBackgroundSprite sprite = new ClientBackgroundSprite(id, this.contents);
            sprite.method_76320(byteBuffer, 0, 0, this.contents.method_45807(), this.contents.method_45815(), size);
            this.gpuBuffer = RenderSystem.getDevice().createBuffer(() -> ((class_2960)id).toString(), 128, byteBuffer);
            this.animator = this.contents.method_45818(this.gpuBuffer.slice(), size);
            this.field_56974 = RenderSystem.getDevice().createTexture(id.toString(), 13, TextureFormat.RGBA8, this.contents.method_45807(), this.contents.method_45815(), 1, 1);
            this.field_60597 = RenderSystem.getDevice().createTextureView(this.field_56974);
            this.contents.method_45809(this.field_56974, 0);
        }

        public void method_4622() {
            if (this.animator != null) {
                this.animator.method_76307();
                try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Animate " + String.valueOf(this.contents.method_45816()), this.field_60597, OptionalInt.empty());){
                    if (this.animator.method_76310()) {
                        this.animator.method_76309(renderPass, this.animator.method_76308(0));
                    }
                }
            }
        }

        public void close() {
            this.gpuBuffer.close();
            this.contents.close();
            if (this.animator != null) {
                this.animator.close();
            }
            super.close();
        }
    }

    private static class ClientBackgroundSprite
    extends class_1058 {
        private ClientBackgroundSprite(class_2960 id, class_7764 contents) {
            super(id, contents, contents.method_45807(), contents.method_45815(), 0, 0, 0);
        }
    }
}

