/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.compostable;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.vanilla.IJeiCompostingRecipe;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.library.plugins.vanilla.compostable.CompostingRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class CompostingRecipeMaker {
    public static List<IJeiCompostingRecipe> getRecipes(IIngredientManager ingredientManager) {
        Collection<class_1799> allIngredients = ingredientManager.getAllItemStacks();
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        IPlatformIngredientHelper platformIngredientHelper = Services.PLATFORM.getIngredientHelper();
        return allIngredients.stream().mapMulti((itemStack, consumer) -> {
            float compostValue = platformIngredientHelper.getCompostValue((class_1799)itemStack);
            if (compostValue > 0.0f) {
                class_2960 ingredientUid = ingredientHelper.getIdentifier(itemStack);
                String ingredientUidPath = ingredientUid.method_12832();
                class_2960 recipeUid = class_2960.method_60655((String)"jei", (String)ingredientUidPath);
                CompostingRecipe recipe = new CompostingRecipe((class_1799)itemStack, compostValue, recipeUid);
                consumer.accept(recipe);
            }
        }).sorted(Comparator.comparingDouble(IJeiCompostingRecipe::getChance)).toList();
    }
}

