/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load.registration;

import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.collect.Table;
import mezz.jei.library.recipes.RecipeTransferManager;
import mezz.jei.library.recipes.UniversalRecipeTransferHandlerAdapter;
import mezz.jei.library.transfer.BasicRecipeTransferHandler;
import mezz.jei.library.transfer.BasicRecipeTransferInfo;
import net.minecraft.class_1703;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferRegistration
implements IRecipeTransferRegistration {
    private final Table<Class<? extends class_1703>, IRecipeType<?>, IRecipeTransferHandler<?, ?>> recipeTransferHandlers = Table.hashBasedTable();
    private final IStackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IJeiHelpers jeiHelpers;
    private final IConnectionToServer serverConnection;

    public RecipeTransferRegistration(IStackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper, IJeiHelpers jeiHelpers, IConnectionToServer serverConnection) {
        this.stackHelper = stackHelper;
        this.handlerHelper = handlerHelper;
        this.jeiHelpers = jeiHelpers;
        this.serverConnection = serverConnection;
    }

    @Override
    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    @Override
    public IRecipeTransferHandlerHelper getTransferHelper() {
        return this.handlerHelper;
    }

    @Override
    public <C extends class_1703, R> void addRecipeTransferHandler(Class<? extends C> containerClass, @Nullable class_3917<C> menuType, IRecipeType<R> recipeType, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        ErrorUtil.checkNotNull(containerClass, "containerClass");
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        BasicRecipeTransferInfo<? extends C, R> recipeTransferInfo = new BasicRecipeTransferInfo<C, R>(containerClass, menuType, recipeType, recipeSlotStart, recipeSlotCount, inventorySlotStart, inventorySlotCount);
        this.addRecipeTransferHandler(recipeTransferInfo);
    }

    @Override
    public <C extends class_1703, R> void addRecipeTransferHandler(IRecipeTransferInfo<C, R> recipeTransferInfo) {
        ErrorUtil.checkNotNull(recipeTransferInfo, "recipeTransferInfo");
        BasicRecipeTransferHandler<C, R> recipeTransferHandler = new BasicRecipeTransferHandler<C, R>(this.serverConnection, this.stackHelper, this.handlerHelper, recipeTransferInfo);
        this.addRecipeTransferHandler(recipeTransferHandler, recipeTransferInfo.getRecipeType());
    }

    @Override
    public <C extends class_1703, R> void addRecipeTransferHandler(IRecipeTransferHandler<C, R> recipeTransferHandler, IRecipeType<R> recipeType) {
        ErrorUtil.checkNotNull(recipeTransferHandler, "recipeTransferHandler");
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        Class<C> containerClass = recipeTransferHandler.getContainerClass();
        this.recipeTransferHandlers.put(containerClass, recipeType, recipeTransferHandler);
    }

    @Override
    public <C extends class_1703> void addUniversalRecipeTransferHandler(IUniversalRecipeTransferHandler<C> universalRecipeTransferHandler) {
        ErrorUtil.checkNotNull(universalRecipeTransferHandler, "universalRecipeTransferHandler");
        Class<C> containerClass = universalRecipeTransferHandler.getContainerClass();
        UniversalRecipeTransferHandlerAdapter adapter = new UniversalRecipeTransferHandlerAdapter(universalRecipeTransferHandler);
        this.recipeTransferHandlers.put(containerClass, adapter.getRecipeType(), adapter);
    }

    public IRecipeTransferManager createRecipeTransferManager() {
        return new RecipeTransferManager(this.recipeTransferHandlers.toImmutable());
    }
}

