/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.content.client;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.GuiLayersContext;
import fuzs.puzzleslib.api.client.event.v1.gui.AddToastCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenMouseEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenOpeningCallback;
import fuzs.puzzleslib.api.client.gui.v2.ScreenHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.impl.content.ServerPropertiesHelper;
import fuzs.puzzleslib.impl.content.client.ScreenSkipper;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1157;
import net.minecraft.class_11631;
import net.minecraft.class_11635;
import net.minecraft.class_11636;
import net.minecraft.class_1761;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3419;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_370;
import net.minecraft.class_4071;
import net.minecraft.class_425;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_481;
import net.minecraft.class_5244;
import net.minecraft.class_525;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_8100;
import net.minecraft.class_8646;

public class PuzzlesLibClientDevelopment
implements ClientModConstructor {
    private static final Map<class_2960, class_11635> DEFAULT_DEBUG_SCREEN_PROFILE = (Map)Stream.of(class_11631.field_61576, class_11631.field_61567, class_11631.field_61569, class_11631.field_61578, class_11631.field_61560, class_11631.field_61559, class_11631.field_61574, class_11631.field_61577, class_11631.field_61564, class_11631.field_61566, class_11631.field_61565, class_11631.field_61562, class_11631.field_61570, class_11631.field_61572, class_11631.field_61573, class_11631.field_61563, class_11631.field_61561).collect(ImmutableMap.toImmutableMap(Function.identity(), identifier -> class_11635.field_61594));

    @Override
    public void onConstructMod() {
        PuzzlesLibClientDevelopment.registerEventHandlers();
        class_11631.field_61557 = ImmutableMap.builder().putAll(class_11631.field_61557).put((Object)class_11636.field_61599, DEFAULT_DEBUG_SCREEN_PROFILE).buildKeepingLast();
    }

    private static void registerEventHandlers() {
        ScreenOpeningCallback.EVENT.register((oldScreen, newScreen) -> {
            if (newScreen instanceof class_442) {
                class_442 screen = (class_442)newScreen;
                screen.field_18222 = false;
            } else if (newScreen instanceof class_525) {
                class_525 screen = (class_525)newScreen;
                screen.method_48657().method_48704(class_8100.class_4539.field_20626);
                screen.method_48657().method_48713(true);
            }
            return EventResultHolder.pass();
        });
        ScreenEvents.beforeInit(class_442.class).register((minecraft, screen, screenWidth, screenHeight, widgets) -> {
            class_4071 patt0$temp = minecraft.method_18506();
            if (patt0$temp instanceof class_425) {
                class_425 loadingOverlay = (class_425)patt0$temp;
                if (loadingOverlay.field_17771 != 0L) {
                    loadingOverlay.field_17771 = 0L;
                }
            }
        });
        AddToastCallback.EVENT.register((toastManager, toast) -> {
            class_370 systemToast;
            if (toast instanceof class_370 && (systemToast = (class_370)toast).method_1989() == class_370.class_9037.field_47589) {
                return EventResult.INTERRUPT;
            }
            return EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseClick(class_437.class).register((screen, mouseButtonEvent) -> {
            for (class_364 guiEventListener : screen.method_25396()) {
                if (!(guiEventListener instanceof class_342) || !guiEventListener.method_25402(mouseButtonEvent, ScreenHelper.isDoubleClick(mouseButtonEvent))) continue;
                screen.method_25395(guiEventListener);
                if (mouseButtonEvent.method_74245() == 0) {
                    screen.method_25398(true);
                }
                return EventResult.INTERRUPT;
            }
            return EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseRelease(class_437.class).register((screen, mouseButtonEvent) -> {
            screen.method_25398(false);
            return screen.method_19355(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799()).filter(class_342.class::isInstance).filter(guiEventListener -> guiEventListener.method_25406(mouseButtonEvent)).isPresent() ? EventResult.INTERRUPT : EventResult.PASS;
        });
        ScreenMouseEvents.beforeMouseDrag(class_437.class).register((screen, mouseButtonEvent, dragX, dragY) -> screen.method_25399() instanceof class_342 && screen.method_25397() && mouseButtonEvent.method_74245() == 0 && screen.method_25399().method_25403(mouseButtonEvent, dragX, dragY) ? EventResult.INTERRUPT : EventResult.PASS);
    }

    @Override
    public void onClientSetup() {
        class_481.field_2896 = (class_1761)class_7923.field_44687.method_31140(class_7706.field_40200);
        PuzzlesLibClientDevelopment.initializeScreenSkipper();
    }

    private static void initializeScreenSkipper() {
        ScreenSkipper.create().setTitleComponent("selectWorld.backupQuestion.experimental").setButtonComponent("selectWorld.backupJoinSkipButton").build();
        ScreenSkipper.create().setTitleComponent("selectWorld.warning.experimental.title").setButtonComponent(class_5244.field_24336).build();
        ScreenSkipper.create().setTitleComponent("controls.title").setButtonComponent("controls.keybinds").setLastTitleComponent("options.title").build();
    }

    public static void setupGameOptions(class_315 options) {
        class_310 minecraft = class_310.method_1551();
        Objects.requireNonNull(minecraft, "minecraft is null");
        boolean running = minecraft.field_1698;
        minecraft.field_1698 = false;
        PuzzlesLibClientDevelopment.initializeGameOptions(options);
        minecraft.field_1698 = running;
    }

    public static void initializeGameOptions(class_315 options) {
        boolean optionsStillMissing = !options.method_37294().exists();
        PuzzlesLibClientDevelopment.unbindKey(options.field_1874, optionsStillMissing);
        PuzzlesLibClientDevelopment.unbindKey(options.field_1879, optionsStillMissing);
        PuzzlesLibClientDevelopment.unbindKey(options.field_1845, optionsStillMissing);
        PuzzlesLibClientDevelopment.unbindKey(options.field_26845, optionsStillMissing);
        PuzzlesLibClientDevelopment.unbindKey(options.field_1844, optionsStillMissing);
        PuzzlesLibClientDevelopment.unbindKey(options.field_60985, optionsStillMissing);
        PuzzlesLibClientDevelopment.unbindKey(options.field_1836, optionsStillMissing);
        if (optionsStillMissing) {
            options.method_42503().method_41748((Object)16);
            options.method_42524().method_41748((Object)60);
            options.method_53530().method_41748((Object)false);
            options.field_1827 = true;
            options.field_1875 = class_1157.field_5653;
            options.field_26844 = true;
            options.method_47395().method_41748((Object)true);
            options.method_42440().method_41748((Object)false);
            options.method_42443().method_41748((Object)true);
            options.method_42474().method_41748((Object)8);
            options.field_41785 = false;
            options.field_21840 = true;
            options.method_48974().method_41748((Object)0.0);
            options.method_45578(class_3419.field_15253).method_41748((Object)0.0);
            options.field_1864 = ServerPropertiesHelper.getHostAddress().map(string -> string + ":25565").orElse("");
        }
    }

    private static void unbindKey(class_304 keyMapping, boolean optionsStillMissing) {
        keyMapping.field_1654 = class_3675.field_16237;
        if (optionsStillMissing) {
            keyMapping.method_1422(class_3675.field_16237);
        }
    }

    @Override
    public void onRegisterGuiLayers(GuiLayersContext context) {
        context.replaceGuiLayer(GuiLayersContext.PLAYER_LIST, layer -> (guiGraphics, deltaTracker) -> {
            class_310 minecraft = class_310.method_1551();
            class_269 scoreboard = minecraft.field_1687.method_8428();
            class_266 objective = scoreboard.method_1189(class_8646.field_45156);
            if (minecraft.field_1690.field_1907.method_1434() && minecraft.method_1542() && minecraft.field_1724.field_3944.method_45732().size() <= 1 && objective == null) {
                minecraft.field_1705.field_2015.method_1921(true);
                minecraft.field_1705.field_2015.method_1919(guiGraphics, guiGraphics.method_51421(), scoreboard, null);
            } else {
                layer.render(guiGraphics, deltaTracker);
            }
        });
    }
}

