/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.client.core.context;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.client.core.v1.context.GuiLayersContext;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudStatusBarHeightRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

public final class GuiLayersContextFabricImpl
implements GuiLayersContext {
    private static final Map<class_2960, class_2960> VANILLA_GUI_LAYERS = ImmutableMap.builder().put((Object)CAMERA_OVERLAYS, (Object)VanillaHudElements.MISC_OVERLAYS).put((Object)CROSSHAIR, (Object)VanillaHudElements.CROSSHAIR).put((Object)HOTBAR, (Object)VanillaHudElements.HOTBAR).put((Object)INFO_BAR, (Object)VanillaHudElements.INFO_BAR).put((Object)PLAYER_HEALTH, (Object)VanillaHudElements.HEALTH_BAR).put((Object)ARMOR_LEVEL, (Object)VanillaHudElements.ARMOR_BAR).put((Object)FOOD_LEVEL, (Object)VanillaHudElements.FOOD_BAR).put((Object)VEHICLE_HEALTH, (Object)VanillaHudElements.MOUNT_HEALTH).put((Object)AIR_LEVEL, (Object)VanillaHudElements.AIR_BAR).put((Object)HELD_ITEM_TOOLTIP, (Object)VanillaHudElements.HELD_ITEM_TOOLTIP).put((Object)EXPERIENCE_LEVEL, (Object)VanillaHudElements.EXPERIENCE_LEVEL).put((Object)SPECTATOR_TOOLTIP, (Object)VanillaHudElements.SPECTATOR_TOOLTIP).put((Object)STATUS_EFFECTS, (Object)VanillaHudElements.STATUS_EFFECTS).put((Object)BOSS_BAR, (Object)VanillaHudElements.BOSS_BAR).put((Object)SLEEP_OVERLAY, (Object)VanillaHudElements.SLEEP).put((Object)DEMO_TIMER, (Object)VanillaHudElements.DEMO_TIMER).put((Object)SCOREBOARD, (Object)VanillaHudElements.SCOREBOARD).put((Object)OVERLAY_MESSAGE, (Object)VanillaHudElements.OVERLAY_MESSAGE).put((Object)TITLE, (Object)VanillaHudElements.TITLE_AND_SUBTITLE).put((Object)CHAT, (Object)VanillaHudElements.CHAT).put((Object)PLAYER_LIST, (Object)VanillaHudElements.PLAYER_LIST).put((Object)SUBTITLES, (Object)VanillaHudElements.SUBTITLES).build();

    public static class_2960 getVanillaGuiLayer(class_2960 identifier) {
        return VANILLA_GUI_LAYERS.getOrDefault(identifier, identifier);
    }

    @Override
    public void registerGuiLayer(class_2960 identifier, GuiLayersContext.Layer guiLayer) {
        Objects.requireNonNull(identifier, "identifier is null");
        Objects.requireNonNull(guiLayer, "gui layer is null");
        HudElementRegistry.addLast((class_2960)identifier, guiLayer::render);
    }

    @Override
    public void registerGuiLayer(class_2960 identifier, class_2960 otherIdentifier, GuiLayersContext.Layer guiLayer) {
        Objects.requireNonNull(identifier, "identifier is null");
        Objects.requireNonNull(otherIdentifier, "other identifier is null");
        Objects.requireNonNull(guiLayer, "gui layer is null");
        if (VANILLA_GUI_LAYERS.containsKey(identifier)) {
            HudElementRegistry.attachElementAfter((class_2960)VANILLA_GUI_LAYERS.get(identifier), (class_2960)otherIdentifier, guiLayer::render);
        } else if (VANILLA_GUI_LAYERS.containsKey(otherIdentifier)) {
            HudElementRegistry.attachElementBefore((class_2960)VANILLA_GUI_LAYERS.get(otherIdentifier), (class_2960)identifier, guiLayer::render);
        } else {
            throw new RuntimeException("Unknown gui layers: " + String.valueOf(identifier) + ", " + String.valueOf(otherIdentifier));
        }
    }

    @Override
    public void replaceGuiLayer(class_2960 identifier, UnaryOperator<GuiLayersContext.Layer> guiLayerFactory) {
        Objects.requireNonNull(identifier, "identifier is null");
        Objects.requireNonNull(guiLayerFactory, "gui layer factory is null");
        if (!VANILLA_GUI_LAYERS.containsKey(identifier)) {
            throw new RuntimeException("Unknown gui layer: " + String.valueOf(identifier));
        }
        HudElementRegistry.replaceElement((class_2960)VANILLA_GUI_LAYERS.get(identifier), hudElement -> ((GuiLayersContext.Layer)guiLayerFactory.apply((arg_0, arg_1) -> ((HudElement)hudElement).render(arg_0, arg_1)))::render);
    }

    @Override
    public void addLeftStatusBarHeightProvider(class_2960 identifier, ToIntFunction<class_1657> heightProvider) {
        Objects.requireNonNull(identifier, "identifier is null");
        Objects.requireNonNull(heightProvider, "height provider is null");
        identifier = GuiLayersContextFabricImpl.getVanillaGuiLayer(identifier);
        HudStatusBarHeightRegistry.addLeft((class_2960)identifier, heightProvider::applyAsInt);
    }

    @Override
    public void addRightStatusBarHeightProvider(class_2960 identifier, ToIntFunction<class_1657> heightProvider) {
        Objects.requireNonNull(identifier, "identifier is null");
        Objects.requireNonNull(heightProvider, "height provider is null");
        identifier = GuiLayersContextFabricImpl.getVanillaGuiLayer(identifier);
        HudStatusBarHeightRegistry.addRight((class_2960)identifier, heightProvider::applyAsInt);
    }
}

