/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8219;

public class DescriptionListWidget
extends class_350<DescriptionEntry> {
    private static final class_2561 HAS_UPDATE_TEXT = class_2561.method_43471((String)"modmenu.hasUpdate");
    private static final class_2561 EXPERIMENTAL_TEXT = class_2561.method_43471((String)"modmenu.experimental").method_27692(class_124.field_1065);
    private static final class_2561 DOWNLOAD_TEXT = class_2561.method_43471((String)"modmenu.downloadLink").method_27692(class_124.field_1078).method_27692(class_124.field_1073);
    private static final class_2561 CHILD_HAS_UPDATE_TEXT = class_2561.method_43471((String)"modmenu.childHasUpdate");
    private static final class_2561 LINKS_TEXT = class_2561.method_43471((String)"modmenu.links");
    private static final class_2561 SOURCE_TEXT = class_2561.method_43471((String)"modmenu.source").method_27692(class_124.field_1078).method_27692(class_124.field_1073);
    private static final class_2561 LICENSE_TEXT = class_2561.method_43471((String)"modmenu.license");
    private static final class_2561 VIEW_CREDITS_TEXT = class_2561.method_43471((String)"modmenu.viewCredits").method_27692(class_124.field_1078).method_27692(class_124.field_1073);
    private static final class_2561 CREDITS_TEXT = class_2561.method_43471((String)"modmenu.credits");
    private final ModsScreen parent;
    private final class_327 textRenderer;
    private Mod selectedMod = null;

    public DescriptionListWidget(class_310 client, int width, int height, int y, int itemHeight, DescriptionListWidget copyFrom, ModsScreen parent) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
        this.textRenderer = client.field_1772;
        if (copyFrom != null) {
            this.updateSelectedMod(copyFrom.selectedMod);
            this.method_44382(copyFrom.method_44387());
        }
        if (parent.getSelectedEntry() != null) {
            this.updateSelectedMod(parent.getSelectedEntry().getMod());
        }
    }

    public DescriptionEntry getSelectedOrNull() {
        return null;
    }

    public int method_25322() {
        return this.field_22758 - 10;
    }

    protected int method_65507() {
        return this.field_22758 - 6 + this.method_46426();
    }

    public void method_47399(class_6382 builder) {
        if (this.selectedMod != null) {
            builder.method_37033(class_6381.field_33788, this.selectedMod.getTranslatedName() + " " + this.selectedMod.getPrefixedVersion());
        }
    }

    private void rebuildUI() {
        block32: {
            SortedMap<String, Set<String>> credits;
            Mod mod;
            int wrapWidth;
            DescriptionEntry emptyEntry;
            block33: {
                if (this.selectedMod == null) {
                    return;
                }
                emptyEntry = new DescriptionEntry(class_5481.field_26385);
                wrapWidth = this.method_25322() - 5;
                mod = this.selectedMod;
                class_2561 description = mod.getFormattedDescription();
                if (!description.getString().isEmpty()) {
                    for (class_5481 line : this.textRenderer.method_1728((class_5348)description, wrapWidth)) {
                        this.method_25321((class_350.class_351)new DescriptionEntry(line));
                    }
                }
                if (ModMenuConfig.UPDATE_CHECKER.getValue() && !ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(mod.getId())) {
                    Object entry;
                    UpdateInfo updateInfo = mod.getUpdateInfo();
                    if (updateInfo != null && updateInfo.isUpdateAvailable()) {
                        this.method_25321((class_350.class_351)emptyEntry);
                        int index = 0;
                        for (Object line : this.textRenderer.method_1728((class_5348)HAS_UPDATE_TEXT, wrapWidth - 11)) {
                            entry = new DescriptionEntry((class_5481)line);
                            if (index == 0) {
                                ((DescriptionEntry)((Object)entry)).setUpdateTextEntry();
                            }
                            this.method_25321((class_350.class_351)entry);
                            ++index;
                        }
                        for (Object line : this.textRenderer.method_1728((class_5348)EXPERIMENTAL_TEXT, wrapWidth - 16)) {
                            this.method_25321((class_350.class_351)new DescriptionEntry((class_5481)line, 8));
                        }
                        class_2561 updateMessage = updateInfo.getUpdateMessage();
                        String downloadLink = updateInfo.getDownloadLink();
                        if (updateMessage == null) {
                            updateMessage = DOWNLOAD_TEXT;
                        } else if (downloadLink != null) {
                            updateMessage = updateMessage.method_27661().method_27692(class_124.field_1078).method_27692(class_124.field_1073);
                        }
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)updateMessage, wrapWidth - 16)) {
                            if (downloadLink != null) {
                                this.method_25321((class_350.class_351)new LinkEntry(line, downloadLink, 8));
                                continue;
                            }
                            this.method_25321((class_350.class_351)new DescriptionEntry(line, 8));
                        }
                    }
                    if (mod.getChildHasUpdate()) {
                        this.method_25321((class_350.class_351)emptyEntry);
                        int index = 0;
                        for (Object line : this.textRenderer.method_1728((class_5348)CHILD_HAS_UPDATE_TEXT, wrapWidth - 11)) {
                            entry = new DescriptionEntry((class_5481)line);
                            if (index == 0) {
                                ((DescriptionEntry)((Object)entry)).setUpdateTextEntry();
                            }
                            this.method_25321((class_350.class_351)entry);
                            ++index;
                        }
                    }
                }
                Map<String, String> links = mod.getLinks();
                String sourceLink = mod.getSource();
                if (!(links.isEmpty() && sourceLink == null || ModMenuConfig.HIDE_MOD_LINKS.getValue())) {
                    this.method_25321((class_350.class_351)emptyEntry);
                    for (Object line : this.textRenderer.method_1728((class_5348)LINKS_TEXT, wrapWidth)) {
                        this.method_25321((class_350.class_351)new DescriptionEntry((class_5481)line));
                    }
                    if (sourceLink != null) {
                        int indent = 8;
                        for (Object line : this.textRenderer.method_1728((class_5348)SOURCE_TEXT, wrapWidth - 16)) {
                            this.method_25321((class_350.class_351)new LinkEntry((class_5481)line, sourceLink, indent));
                            indent = 16;
                        }
                    }
                    links.forEach((key, value) -> {
                        int indent = 8;
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43471((String)key).method_27692(class_124.field_1078).method_27692(class_124.field_1073), wrapWidth - 16)) {
                            this.method_25321((class_350.class_351)new LinkEntry(line, (String)value, indent));
                            indent = 16;
                        }
                    });
                }
                Set<String> licenses = mod.getLicense();
                if (!ModMenuConfig.HIDE_MOD_LICENSE.getValue() && !licenses.isEmpty()) {
                    this.method_25321((class_350.class_351)emptyEntry);
                    for (Object line : this.textRenderer.method_1728((class_5348)LICENSE_TEXT, wrapWidth)) {
                        this.method_25321((class_350.class_351)new DescriptionEntry((class_5481)line));
                    }
                    for (String license : licenses) {
                        int indent = 8;
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)license), wrapWidth - 16)) {
                            this.method_25321((class_350.class_351)new DescriptionEntry(line, indent));
                            indent = 16;
                        }
                    }
                }
                if (ModMenuConfig.HIDE_MOD_CREDITS.getValue()) break block32;
                if (!"minecraft".equals(mod.getId())) break block33;
                this.method_25321((class_350.class_351)emptyEntry);
                for (Object line : this.textRenderer.method_1728((class_5348)VIEW_CREDITS_TEXT, wrapWidth)) {
                    this.method_25321((class_350.class_351)new MojangCreditsEntry((class_5481)line));
                }
                break block32;
            }
            if ("java".equals(mod.getId()) || (credits = mod.getCredits()).isEmpty()) break block32;
            this.method_25321((class_350.class_351)emptyEntry);
            for (class_5481 line : this.textRenderer.method_1728((class_5348)CREDITS_TEXT, wrapWidth)) {
                this.method_25321((class_350.class_351)new DescriptionEntry(line));
            }
            Iterator<Map.Entry<String, Set<String>>> iterator = credits.entrySet().iterator();
            while (iterator.hasNext()) {
                int indent = 8;
                Map.Entry<String, Set<String>> role = iterator.next();
                for (class_5481 line : this.textRenderer.method_1728((class_5348)this.creditsRoleText(role.getKey()), wrapWidth - 16)) {
                    this.method_25321((class_350.class_351)new DescriptionEntry(line, indent));
                    indent = 16;
                }
                for (String contributor : role.getValue()) {
                    indent = 16;
                    for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)contributor), wrapWidth - 24)) {
                        ContactInformation contact = mod.getContact(contributor);
                        if (contact != null && contact.get("email").isPresent()) {
                            this.method_25321((class_350.class_351)new MailableContactEntry(line, (String)contact.get("email").get(), indent));
                        } else {
                            this.method_25321((class_350.class_351)new DescriptionEntry(line, indent));
                        }
                        indent = 24;
                    }
                }
                if (!iterator.hasNext()) continue;
                this.method_25321((class_350.class_351)emptyEntry);
            }
        }
    }

    public void updateSelectedMod(Mod mod) {
        this.selectedMod = mod;
        this.method_25339();
        this.method_44382(-1.7976931348623157E308);
        this.rebuildUI();
    }

    public void method_25311(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.method_49603(drawContext);
        super.method_25311(drawContext, mouseX, mouseY, delta);
        drawContext.method_44380();
    }

    private class_2561 creditsRoleText(String roleName) {
        String translationKey = roleName.replaceAll("[ -]", "_").toLowerCase();
        Object fallback = roleName.endsWith("r") ? roleName + "s" : roleName;
        return class_2561.method_48321((String)("modmenu.credits.role." + translationKey), (String)fallback).method_10852((class_2561)class_2561.method_43470((String)":"));
    }

    protected class DescriptionEntry
    extends class_4265.class_4266<DescriptionEntry> {
        protected class_5481 text;
        protected int indent;
        public boolean updateTextEntry = false;

        public DescriptionEntry(class_5481 text, int indent) {
            this.text = text;
            this.indent = indent;
        }

        public DescriptionEntry(class_5481 text) {
            this(text, 0);
        }

        public DescriptionEntry setUpdateTextEntry() {
            this.updateTextEntry = true;
            return this;
        }

        public void method_25343(class_332 drawContext, int mouseX, int mouseY, boolean isSelected, float delta) {
            int x = this.method_46426();
            int y = this.method_73382();
            if (this.updateTextEntry) {
                UpdateAvailableBadge.renderBadge(drawContext, x + this.indent, y);
                x += 11;
            }
            drawContext.method_35720(DescriptionListWidget.this.textRenderer, this.text, x + this.indent, y, -5592406);
        }

        public boolean method_25405(double mouseX, double mouseY) {
            double relativeX;
            if (!super.method_25405(mouseX, mouseY)) {
                return false;
            }
            int width = DescriptionListWidget.this.textRenderer.method_30880(this.text);
            if (this.updateTextEntry) {
                width += 11;
            }
            return (relativeX = mouseX - (double)DescriptionListWidget.this.method_25342() - (double)this.indent) >= 0.0 && relativeX < (double)width;
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> method_37025() {
            return Collections.emptyList();
        }
    }

    protected class LinkEntry
    extends DescriptionEntry {
        private final String link;

        public LinkEntry(class_5481 text, String link, int indent) {
            super(text, indent);
            this.link = link;
        }

        public LinkEntry(class_5481 text, String link) {
            this(text, link, 0);
        }

        public boolean method_25402(class_11909 click, boolean doubleClick) {
            if (this.method_25405(click.comp_4798(), click.comp_4799())) {
                DescriptionListWidget.this.field_22740.method_1507((class_437)new class_407(open -> {
                    if (open) {
                        class_156.method_668().method_670(this.link);
                    }
                    DescriptionListWidget.this.field_22740.method_1507((class_437)DescriptionListWidget.this.parent);
                }, this.link, false));
            }
            return super.method_25402(click, doubleClick);
        }
    }

    protected class MojangCreditsEntry
    extends DescriptionEntry {
        public MojangCreditsEntry(class_5481 text) {
            super(text);
        }

        public boolean method_25402(class_11909 click, boolean doubleClick) {
            if (this.method_25405(click.comp_4798(), click.comp_4799())) {
                DescriptionListWidget.this.field_22740.method_1507((class_437)new MinecraftCredits(this));
            }
            return super.method_25402(click, doubleClick);
        }

        class MinecraftCredits
        extends class_8219 {
            public MinecraftCredits(MojangCreditsEntry this$1) {
                super((class_437)this$1.DescriptionListWidget.this.parent);
            }
        }
    }

    protected class MailableContactEntry
    extends DescriptionEntry {
        private final String email;

        public MailableContactEntry(class_5481 text, String email, int indent) {
            super(text, indent);
            this.email = email;
        }

        public MailableContactEntry(class_5481 text, String link) {
            this(text, link, 0);
        }

        @Override
        public void method_25343(class_332 drawContext, int mouseX, int mouseY, boolean isSelected, float delta) {
            super.method_25343(drawContext, mouseX, mouseY, isSelected, delta);
            drawContext.method_27535(DescriptionListWidget.this.textRenderer, (class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43470((String)"\u2709")), this.method_73380() + this.indent + DescriptionListWidget.this.textRenderer.method_30880(this.text) + 1, this.method_73382(), -5592406);
        }

        public boolean method_25402(class_11909 click, boolean doubled) {
            if (this.method_25405(click.comp_4798(), click.comp_4799())) {
                DescriptionListWidget.this.field_22740.method_1507((class_437)new class_407(open -> {
                    if (open) {
                        class_156.method_668().method_670("mailto:" + this.email);
                    }
                    DescriptionListWidget.this.field_22740.method_1507((class_437)DescriptionListWidget.this.parent);
                }, "mailto:" + this.email, false));
            }
            return super.method_25402(click, doubled);
        }
    }
}

