/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.herenthere.placeholder.util;

import dev.terminalmc.herenthere.placeholder.Placeholders;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerPositionUtil {
    @Nullable
    private static class_243 playerPos;
    @Nullable
    private static class_2338 playerBlockPos;
    @Nullable
    private static class_2338 lookBlockPos;
    @Nullable
    private static class_243 lookAngle;
    @Nullable
    private static class_241 rotation;

    public static void reset() {
        playerPos = null;
        playerBlockPos = null;
        lookBlockPos = null;
        lookAngle = null;
        rotation = null;
    }

    @NotNull
    private static class_243 getPlayerPos() {
        if (playerPos == null) {
            playerPos = class_310.method_1551().field_1724.method_73189();
        }
        return playerPos;
    }

    @NotNull
    private static class_2338 getPlayerBlockPos() {
        if (playerBlockPos == null) {
            playerBlockPos = class_310.method_1551().field_1724.method_24515();
        }
        return playerBlockPos;
    }

    @Nullable
    private static class_2338 getLookBlockPos() {
        if (lookBlockPos == null) {
            class_310 mc = class_310.method_1551();
            class_239 result = mc.field_1724.method_5745(Math.max(384.0, (mc.field_1769.method_34812() + 1.0) * 16.0), 0.0f, false);
            if (result.method_17783().equals((Object)class_239.class_240.field_1332)) {
                lookBlockPos = ((class_3965)result).method_17777();
            }
        }
        return lookBlockPos;
    }

    @NotNull
    private static class_243 getLookAngle() {
        if (lookAngle == null) {
            lookAngle = class_310.method_1551().field_1724.method_5720();
        }
        return lookAngle;
    }

    @NotNull
    private static class_241 getRotation() {
        if (rotation == null) {
            rotation = class_310.method_1551().field_1724.method_5802();
        }
        return rotation;
    }

    public static String getPosString(String[] groups) {
        class_243 pos;
        double forwardsCaret;
        if (groups.length != 6) {
            return Placeholders.fault();
        }
        boolean look = groups[0].equals("l");
        boolean decimal = groups[1].equals("d");
        String delimiter = groups[2];
        double leftCaret = groups[3] == null ? 0.0 : Double.parseDouble(groups[3]);
        double upCaret = groups[4] == null ? 0.0 : Double.parseDouble(groups[4]);
        double d = forwardsCaret = groups[5] == null ? 0.0 : Double.parseDouble(groups[5]);
        if (look) {
            class_2338 lookPos = PlayerPositionUtil.getLookBlockPos();
            class_243 class_2432 = pos = lookPos == null ? null : lookPos.method_61082();
            if (pos == null) {
                return Placeholders.fault();
            }
        } else {
            pos = decimal ? PlayerPositionUtil.getPlayerPos() : PlayerPositionUtil.getPlayerBlockPos().method_61082();
        }
        pos = PlayerPositionUtil.applyCaret(pos, leftCaret, upCaret, forwardsCaret);
        if (decimal) {
            return String.format("%f%s%f%s%f", pos.field_1352, delimiter, pos.field_1351, delimiter, pos.field_1350);
        }
        return String.format("%d%s%d%s%d", class_3532.method_15357((double)pos.field_1352), delimiter, class_3532.method_15357((double)pos.field_1351), delimiter, class_3532.method_15357((double)pos.field_1350));
    }

    private static class_243 applyCaret(class_243 pos, double left, double up, double forwards) {
        class_241 rot = PlayerPositionUtil.getRotation();
        float f = class_3532.method_15362((double)(((double)rot.field_1342 + 90.0) * (Math.PI / 180)));
        float g = class_3532.method_15374((double)(((double)rot.field_1342 + 90.0) * (Math.PI / 180)));
        float h = class_3532.method_15362((double)((double)(-rot.field_1343) * (Math.PI / 180)));
        float i = class_3532.method_15374((double)((double)(-rot.field_1343) * (Math.PI / 180)));
        float j = class_3532.method_15362((double)(((double)(-rot.field_1343) + 90.0) * (Math.PI / 180)));
        float k = class_3532.method_15374((double)(((double)(-rot.field_1343) + 90.0) * (Math.PI / 180)));
        class_243 vec32 = new class_243((double)(f * h), (double)i, (double)(g * h));
        class_243 vec33 = new class_243((double)(f * j), (double)k, (double)(g * j));
        class_243 vec34 = vec32.method_1036(vec33).method_1021(-1.0);
        double d = vec32.field_1352 * forwards + vec33.field_1352 * up + vec34.field_1352 * left;
        double e = vec32.field_1351 * forwards + vec33.field_1351 * up + vec34.field_1351 * left;
        double l = vec32.field_1350 * forwards + vec33.field_1350 * up + vec34.field_1350 * left;
        return new class_243(pos.field_1352 + d, pos.field_1351 + e, pos.field_1350 + l);
    }

    public static String getPosComponentString(String[] groups) {
        class_243 pos;
        double operand;
        if (groups.length != 5) {
            return Placeholders.fault();
        }
        boolean look = groups[0].equals("l");
        String component = groups[1];
        boolean decimal = groups[2].equals("d");
        String operator = groups[3];
        double d = operand = groups[4] == null ? 0.0 : Double.parseDouble(groups[4]);
        if (look) {
            class_2338 lookPos = PlayerPositionUtil.getLookBlockPos();
            class_243 class_2432 = pos = lookPos == null ? null : lookPos.method_61082();
            if (pos == null) {
                return Placeholders.fault();
            }
        } else {
            pos = decimal ? PlayerPositionUtil.getPlayerPos() : PlayerPositionUtil.getPlayerBlockPos().method_61082();
        }
        double value = switch (component) {
            case "x" -> pos.field_1352;
            case "y" -> pos.field_1351;
            case "z" -> pos.field_1350;
            default -> throw new IllegalArgumentException();
        };
        if (operator != null) {
            value = switch (operator) {
                case "+" -> value + operand;
                case "-" -> value - operand;
                case "*" -> value * operand;
                case "/" -> value / operand;
                default -> throw new IllegalArgumentException();
            };
        }
        if (decimal) {
            return String.format("%f", value);
        }
        return String.format("%d", class_3532.method_15357((double)value));
    }

    public static String getFacingAngleString(String[] groups) {
        if (groups.length != 3) {
            return Placeholders.fault();
        }
        String delimiter = groups[0];
        @Nullable String operator = groups[1];
        double operand = groups[2] == null ? 0.0 : Double.parseDouble(groups[2]);
        class_243 vec = PlayerPositionUtil.getLookAngle();
        if (operator != null) {
            vec = switch (operator) {
                case "+" -> vec.method_1019(vec.method_1021(operand));
                case "-" -> vec.method_1020(vec.method_1021(operand));
                case "*" -> vec.method_1021(operand);
                case "/" -> vec.method_1021(1.0 / operand);
                default -> throw new IllegalArgumentException();
            };
        }
        return String.format("%f%s%f%s%f", vec.field_1352, delimiter, vec.field_1351, delimiter, vec.field_1350);
    }
}

