/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.network.payloads;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import net.xstopho.resourceconfigapi.ConfigConstants;
import net.xstopho.resourceconfigapi.api.ConfigRegistry;
import net.xstopho.resourceconfigapi.config.ModConfig;
import net.xstopho.resourceconfigapi.network.ConfigNetwork;
import net.xstopho.resourceconfigapi.network.payloads.ConfigSyncPayload;

public record ConfigUpdatePayload(String file, String json) implements class_8710
{
    public static final class_8710.class_9154<ConfigUpdatePayload> TYPE = ConfigConstants.type("config_update_payload");
    public static final class_9139<class_9129, ConfigUpdatePayload> CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, ConfigUpdatePayload::file, (class_9139)class_9135.field_48554, ConfigUpdatePayload::json, ConfigUpdatePayload::new);

    public static void handle(ConfigUpdatePayload payload, MinecraftServer server) {
        if (server == null || payload.file().contains("client")) {
            return;
        }
        server.execute(() -> {
            JsonObject jsonObject = JsonParser.parseString((String)payload.json()).getAsJsonObject();
            class_2960 configLocation = class_2960.method_60654((String)payload.file());
            if (ConfigRegistry.contains(configLocation)) {
                ConfigConstants.LOG.info("Receive update for Config: {}", (Object)configLocation);
                ModConfig config = ConfigRegistry.getConfig(configLocation);
                config.fromJson(jsonObject);
                config.save();
            }
            ConfigConstants.LOG.info("Sync config changes with Player");
            server.method_3760().method_14571().forEach(player -> ConfigNetwork.INSTANCE.sendToClient((class_3222)player, new ConfigSyncPayload(payload.file(), payload.json())));
        });
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

