/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.config;

import java.lang.reflect.Field;
import java.util.LinkedList;
import net.xstopho.resourceconfigapi.annotations.Config;
import net.xstopho.resourceconfigapi.annotations.ConfigEntry;
import net.xstopho.resourceconfigapi.client.gui.screen.ResourceConfigScreen;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.base.BaseEntry;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.entries.CategoryEntry;
import net.xstopho.resourceconfigapi.client.util.ValueEntryCreator;
import net.xstopho.resourceconfigapi.config.ModConfig;
import net.xstopho.resourceconfigapi.util.ConfigUtils;

public class ConfigHolder {
    private final ModConfig config;
    private final String fileName;
    private final LinkedList<BaseEntry> entryList;

    public ConfigHolder(ModConfig config, ResourceConfigScreen screen) {
        this.config = config;
        Config annotation = config.clazz.getAnnotation(Config.class);
        this.fileName = annotation.fileName();
        this.entryList = this.createEntries(screen);
    }

    private LinkedList<BaseEntry> createEntries(ResourceConfigScreen screen) {
        LinkedList<BaseEntry> entries = new LinkedList<BaseEntry>();
        String currentCategory = "";
        for (Field field : this.config.clazz.getDeclaredFields()) {
            ConfigEntry entry = field.getAnnotation(ConfigEntry.class);
            if (ConfigUtils.unsupportedDatatype(field) || entry == null) continue;
            String fieldCategory = entry.category();
            if (this.notEmpty(fieldCategory) && !fieldCategory.equals(currentCategory)) {
                currentCategory = fieldCategory;
                entries.add(new CategoryEntry(screen, this.getModId(), this.fileName, currentCategory));
            }
            String translationKey = this.notEmpty(entry.translation()) ? entry.translation() : field.getName();
            entries.add(ValueEntryCreator.create(screen, this.getModId(), this.fileName, translationKey, field, this.config.getDefaultValue(field)));
        }
        return entries;
    }

    public LinkedList<BaseEntry> getEntryList() {
        return this.entryList;
    }

    public ModConfig getConfig() {
        return this.config;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getModId() {
        return this.config.modId;
    }

    private boolean notEmpty(String string) {
        return string != null && !string.isBlank();
    }
}

