/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.xstopho.resourceconfigapi.ConfigConstants;
import net.xstopho.resourceconfigapi.client.util.GuiUtils;
import net.xstopho.resourceconfigapi.platform.PlatformHelper;

public class ComponentUtils {
    public static final LinkedList<class_2561> NEEDED_TRANSLATION = new LinkedList();
    public static final LinkedList<class_2561> OPTIONAL_TRANSLATION = new LinkedList();

    public static class_2561 title(String key) {
        return ComponentUtils.build(String.format("%s.%s", key, "title"));
    }

    public static class_2561 label(String key) {
        return ComponentUtils.build(String.format("%s.%s", key, "label"));
    }

    public static class_2561 tooltip(String key) {
        return ComponentUtils.build(String.format("%s.%s", key, "tooltip"));
    }

    public static class_2561 modConfig(String modId, String key) {
        return ComponentUtils.build(String.format("%s.%s", modId, key));
    }

    public static class_2561 modLabel(String modId, String fileName, String key) {
        return ComponentUtils.label(String.format("%s.%s.%s", modId, fileName, key));
    }

    public static class_2561 modTooltip(String modId, String fileName, String key) {
        return ComponentUtils.tooltip(String.format("%s.%s.%s", modId, fileName, key));
    }

    private static class_2561 build(String key) {
        class_5250 component = class_2561.method_43471((String)String.format("%s.%s", "config", ComponentUtils.convert(key)));
        if (GuiUtils.hasTranslation((class_2561)component)) {
            return component;
        }
        if (component.getString().contains("tooltip")) {
            ComponentUtils.addIfAbsent(OPTIONAL_TRANSLATION, (class_2561)component);
        } else {
            ComponentUtils.addIfAbsent(NEEDED_TRANSLATION, (class_2561)component);
        }
        return component;
    }

    private static String convert(String key) {
        return key.toLowerCase().replace(" ", "_");
    }

    public static void loggMissingTranslations(String modId) {
        if (!PlatformHelper.INSTANCE.isDevEnv()) {
            return;
        }
        ComponentUtils.logMissingTranslations(modId, NEEDED_TRANSLATION, "The following keys are necessary for the User to properly edit your Configs!");
        ComponentUtils.logMissingTranslations(modId, OPTIONAL_TRANSLATION, "The following keys are optional, they add a Tooltip to the Label, this might help to explain some Options to the User.");
    }

    private static void logMissingTranslations(String modId, LinkedList<class_2561> translations, String message) {
        if (!translations.isEmpty()) {
            ConfigConstants.LOG.info("\nYour Config/s for '{}' contains untranslated keys.\n{}\n\n{}", new Object[]{modId, message, ComponentUtils.buildLog(modId, translations)});
        }
    }

    private static String buildLog(String modId, LinkedList<class_2561> components) {
        List<class_2561> modComponents = ComponentUtils.collectModComponents(modId, components);
        StringBuilder builder = new StringBuilder();
        Iterator<class_2561> it = modComponents.iterator();
        while (it.hasNext()) {
            class_2561 comp = it.next();
            if (comp.getString().contains(modId)) {
                builder.append("\"").append(comp.getString()).append("\": \"\"");
            }
            if (it.hasNext()) {
                builder.append(",\n");
                continue;
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private static List<class_2561> collectModComponents(String modId, List<class_2561> list) {
        LinkedList<class_2561> modComponents = new LinkedList<class_2561>();
        for (class_2561 comp : list) {
            if (!comp.getString().contains(modId)) continue;
            modComponents.add(comp);
        }
        return modComponents;
    }

    private static void addIfAbsent(List<class_2561> list, class_2561 component) {
        if (list.contains(component)) {
            return;
        }
        list.add(component);
    }
}

